/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.QueryDetail;
import org.apache.doris.qe.QueryDetailQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QueryDetailAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(QueryDetailAction.class);

    @RequestMapping(path={"/api/query_detail"}, method={RequestMethod.GET})
    protected Object query_detail(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String eventTimeStr = request.getParameter("event_time");
        if (Strings.isNullOrEmpty((String)eventTimeStr)) {
            return ResponseEntityBuilder.badRequest("Missing event_time");
        }
        long eventTime = Long.valueOf(eventTimeStr.trim());
        List<QueryDetail> queryDetails = QueryDetailQueue.getQueryDetails(eventTime);
        HashMap result = Maps.newHashMap();
        result.put("query_details", queryDetails);
        return ResponseEntityBuilder.ok(result);
    }
}

