/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProfileAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(ProfileAction.class);

    @RequestMapping(path={"/api/profile"}, method={RequestMethod.GET})
    protected Object profile(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String queryId = request.getParameter("query_id");
        if (Strings.isNullOrEmpty((String)queryId)) {
            return ResponseEntityBuilder.badRequest("Missing query_id");
        }
        String queryProfileStr = ProfileManager.getInstance().getProfile(queryId);
        if (queryProfileStr == null) {
            return ResponseEntityBuilder.okWithCommonError("query id " + queryId + " not found.");
        }
        HashMap result = Maps.newHashMap();
        result.put("profile", queryProfileStr);
        return ResponseEntityBuilder.ok(result);
    }
}

