/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.DdlException;
import org.apache.doris.httpv2.entity.RestBaseResult;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.service.ExecuteEnv;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class MultiAction
extends RestBaseController {
    private ExecuteEnv execEnv;
    private static final String SUB_LABEL_KEY = "sub_label";

    @RequestMapping(path={"/api/{db}/_multi_desc"}, method={RequestMethod.POST})
    public Object multi_desc(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.executeCheckPassword(request, response);
            this.execEnv = ExecuteEnv.getInstance();
            String label = request.getParameter("label");
            if (Strings.isNullOrEmpty((String)label)) {
                return new RestBaseResult("No label selected");
            }
            String fullDbName = this.getFullDbName(dbName);
            this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, PrivPredicate.LOAD);
            RedirectView redirectView = this.redirectToMaster(request, response);
            if (redirectView != null) {
                return redirectView;
            }
            this.execEnv = ExecuteEnv.getInstance();
            ArrayList labels = Lists.newArrayList();
            this.execEnv.getMultiLoadMgr().desc(fullDbName, label, labels);
            return new MultiLabelResult(labels);
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{db}/_multi_list"}, method={RequestMethod.POST})
    public Object multi_list(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) throws DdlException {
        try {
            this.executeCheckPassword(request, response);
            this.execEnv = ExecuteEnv.getInstance();
            String fullDbName = this.getFullDbName(dbName);
            this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, PrivPredicate.LOAD);
            RedirectView redirectView = this.redirectToMaster(request, response);
            if (redirectView != null) {
                return redirectView;
            }
            ArrayList labels = Lists.newArrayList();
            this.execEnv.getMultiLoadMgr().list(fullDbName, labels);
            return new MultiLabelResult(labels);
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{db}/_multi_start"}, method={RequestMethod.POST})
    public Object multi_start(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) throws DdlException {
        try {
            String value;
            String[] keys;
            this.executeCheckPassword(request, response);
            this.execEnv = ExecuteEnv.getInstance();
            String label = request.getParameter("label");
            if (Strings.isNullOrEmpty((String)label)) {
                return new RestBaseResult("No label selected");
            }
            String fullDbName = this.getFullDbName(dbName);
            this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, PrivPredicate.LOAD);
            RedirectView redirectView = this.redirectToMaster(request, response);
            if (redirectView != null) {
                return redirectView;
            }
            HashMap properties = Maps.newHashMap();
            for (String key : keys = new String[]{"timeout", "max_filter_ratio"}) {
                value = request.getParameter(key);
                if (Strings.isNullOrEmpty((String)value)) continue;
                properties.put(key, value);
            }
            for (String key : keys) {
                value = request.getHeader(key);
                if (Strings.isNullOrEmpty((String)value)) continue;
                properties.put(key, value);
            }
            this.execEnv.getMultiLoadMgr().startMulti(fullDbName, label, properties);
            return RestBaseResult.getOk();
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{db}/_multi_unload"}, method={RequestMethod.POST})
    public Object multi_unload(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.executeCheckPassword(request, response);
            this.execEnv = ExecuteEnv.getInstance();
            String label = request.getParameter("label");
            if (Strings.isNullOrEmpty((String)label)) {
                return new RestBaseResult("No label selected");
            }
            String subLabel = request.getParameter(SUB_LABEL_KEY);
            if (Strings.isNullOrEmpty((String)subLabel)) {
                return new RestBaseResult("No sub label selected");
            }
            String fullDbName = this.getFullDbName(dbName);
            this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, PrivPredicate.LOAD);
            RedirectView redirectView = this.redirectToMaster(request, response);
            if (redirectView != null) {
                return redirectView;
            }
            this.execEnv.getMultiLoadMgr().unload(fullDbName, label, subLabel);
            return RestBaseResult.getOk();
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{db}/_multi_commit"}, method={RequestMethod.POST})
    public Object multi_commit(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) throws DdlException {
        try {
            this.executeCheckPassword(request, response);
            this.execEnv = ExecuteEnv.getInstance();
            String label = request.getParameter("label");
            if (Strings.isNullOrEmpty((String)label)) {
                return new RestBaseResult("No label selected");
            }
            String fullDbName = this.getFullDbName(dbName);
            this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, PrivPredicate.LOAD);
            RedirectView redirectView = this.redirectToMaster(request, response);
            if (redirectView != null) {
                return redirectView;
            }
            try {
                this.execEnv.getMultiLoadMgr().commit(fullDbName, label);
            }
            catch (Exception e) {
                return new RestBaseResult(e.getMessage());
            }
            return RestBaseResult.getOk();
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{db}/_multi_abort"}, method={RequestMethod.POST})
    public Object multi_abort(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) throws DdlException {
        try {
            this.executeCheckPassword(request, response);
            this.execEnv = ExecuteEnv.getInstance();
            String label = request.getParameter("label");
            if (Strings.isNullOrEmpty((String)label)) {
                return new RestBaseResult("No label selected");
            }
            String fullDbName = this.getFullDbName(dbName);
            this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, PrivPredicate.LOAD);
            RedirectView redirectView = this.redirectToMaster(request, response);
            if (redirectView != null) {
                return redirectView;
            }
            this.execEnv.getMultiLoadMgr().abort(fullDbName, label);
            return RestBaseResult.getOk();
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    private static class MultiLabelResult
    extends RestBaseResult {
        private List<String> labels;

        public MultiLabelResult(List<String> labels) {
            this.labels = labels;
        }
    }
}

