/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.metric.JsonMetricVisitor;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.metric.MetricVisitor;
import org.apache.doris.metric.PrometheusMetricVisitor;
import org.apache.doris.metric.SimpleCoreMetricVisitor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetricsAction {
    private static final String TYPE_PARAM = "type";

    @RequestMapping(path={"/metrics"})
    public void execute(HttpServletRequest request, HttpServletResponse response) {
        String type = request.getParameter(TYPE_PARAM);
        MetricVisitor visitor = null;
        visitor = !Strings.isNullOrEmpty((String)type) && type.equalsIgnoreCase("core") ? new SimpleCoreMetricVisitor("doris_fe") : (!Strings.isNullOrEmpty((String)type) && type.equalsIgnoreCase("json") ? new JsonMetricVisitor("doris_fe") : new PrometheusMetricVisitor("doris_fe"));
        response.setContentType("text/plain");
        try {
            response.getWriter().write(MetricRepo.getMetric(visitor));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

