/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.exception.BadRequestException;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaInfoAction
extends RestBaseController {
    private static final String NAMESPACES = "namespaces";
    private static final String DATABASES = "databases";
    private static final String TABLES = "tables";
    private static final String PARAM_LIMIT = "limit";
    private static final String PARAM_OFFSET = "offset";
    private static final String PARAM_WITH_MV = "with_mv";

    @RequestMapping(path={"/api/meta/namespaces/{ns}/databases"}, method={RequestMethod.GET})
    public Object getAllDatabases(@PathVariable(value="ns") String ns, HttpServletRequest request, HttpServletResponse response) {
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        List<String> dbNames = null;
        try {
            dbNames = Catalog.getCurrentCatalog().getClusterDbNames(ns);
        }
        catch (AnalysisException e) {
            return ResponseEntityBuilder.okWithCommonError("namespace does not exist: " + ns);
        }
        ArrayList dbNameSet = Lists.newArrayList();
        for (String fullName : dbNames) {
            String db = ClusterNamespace.getNameFromFullName(fullName);
            if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), fullName, PrivPredicate.SHOW)) continue;
            dbNameSet.add(db);
        }
        Collections.sort(dbNames);
        Pair<Integer, Integer> fromToIndex = this.getFromToIndex(request, dbNames.size());
        return ResponseEntityBuilder.ok(dbNames.subList((Integer)fromToIndex.first, (Integer)fromToIndex.second));
    }

    @RequestMapping(path={"/api/meta/namespaces/{ns}/databases/{db}/tables"}, method={RequestMethod.GET})
    public Object getTables(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        Database db;
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        ArrayList tblNames = Lists.newArrayList();
        for (Table tbl : db.getTables()) {
            if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), fullDbName, tbl.getName(), PrivPredicate.SHOW)) continue;
            tblNames.add(tbl.getName());
        }
        Collections.sort(tblNames);
        Pair<Integer, Integer> fromToIndex = this.getFromToIndex(request, tblNames.size());
        return ResponseEntityBuilder.ok(tblNames.subList((Integer)fromToIndex.first, (Integer)fromToIndex.second));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/meta/namespaces/{ns}/databases/{db}/tables/{table}/schema"}, method={RequestMethod.GET})
    public Object getTableSchema(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) throws UserException {
        Object tbl;
        Database db;
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.SHOW);
        String withMvPara = request.getParameter(PARAM_WITH_MV);
        boolean withMv = !Strings.isNullOrEmpty((String)withMvPara) && withMvPara.equals("1");
        HashMap result = Maps.newHashMap();
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
            tbl = db.getTableOrMetaException(tblName, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        ((Table)tbl).readLock();
        try {
            long baseId = -1L;
            baseId = ((Table)tbl).getType() == Table.TableType.OLAP ? ((OlapTable)tbl).getBaseIndexId() : (baseId += ((Table)tbl).getId());
            String procPath = Joiner.on((String)"/").join((Object)"", (Object)"dbs", new Object[]{db.getId(), ((Table)tbl).getId(), "index_schema/", baseId});
            this.generateResult(tblName, true, procPath, result);
            if (withMv && ((Table)tbl).getType() == Table.TableType.OLAP) {
                OlapTable olapTable = (OlapTable)tbl;
                for (long indexId : olapTable.getIndexIdListExceptBaseIndex()) {
                    procPath = Joiner.on((String)"/").join((Object)"", (Object)"dbs", new Object[]{db.getId(), ((Table)tbl).getId(), "index_schema/", indexId});
                    this.generateResult(olapTable.getIndexNameById(indexId), false, procPath, result);
                }
            }
        }
        finally {
            ((Table)tbl).readUnlock();
        }
        return ResponseEntityBuilder.ok(result);
    }

    private void generateResult(String indexName, boolean isBaseIndex, String procPath, Map<String, Map<String, Object>> result) throws UserException {
        HashMap propMap = result.get(indexName);
        if (propMap == null) {
            propMap = Maps.newHashMap();
            result.put(indexName, propMap);
        }
        propMap.put("is_base", isBaseIndex);
        propMap.put("schema", this.generateSchema(procPath));
    }

    List<Map<String, String>> generateSchema(String procPath) throws UserException {
        ProcNodeInterface node = ProcService.getInstance().open(procPath);
        if (node == null) {
            throw new DdlException("get schema with proc path failed: " + procPath);
        }
        ArrayList schema = Lists.newArrayList();
        ProcResult procResult = node.fetchResult();
        List<String> colNames = procResult.getColumnNames();
        List<List<String>> rows = procResult.getRows();
        for (List<String> row : rows) {
            Preconditions.checkState((row.size() == colNames.size() ? 1 : 0) != 0);
            HashMap fieldMap = Maps.newHashMap();
            for (int i = 0; i < row.size(); ++i) {
                fieldMap.put(colNames.get(i), this.convertIfNull(row.get(i)));
            }
            schema.add(fieldMap);
        }
        return schema;
    }

    private String convertIfNull(String val) {
        return val.equals(FeConstants.null_string) ? null : val;
    }

    private Pair<Integer, Integer> getFromToIndex(HttpServletRequest request, int maxNum) {
        String limitStr = request.getParameter(PARAM_LIMIT);
        String offsetStr = request.getParameter(PARAM_OFFSET);
        int offset = 0;
        int limit = Integer.MAX_VALUE;
        if (Strings.isNullOrEmpty((String)limitStr)) {
            if (!Strings.isNullOrEmpty((String)offsetStr)) {
                throw new BadRequestException("Param offset should be set with param limit");
            }
        } else {
            limit = Integer.valueOf(limitStr);
            if (limit < 0) {
                throw new BadRequestException("Param limit should >= 0");
            }
            offset = 0;
            if (!Strings.isNullOrEmpty((String)offsetStr) && (offset = Integer.valueOf(offsetStr).intValue()) < 0) {
                throw new BadRequestException("Param offset should >= 0");
            }
        }
        if (maxNum <= 0) {
            return Pair.create(0, 0);
        }
        return Pair.create(Math.min(offset, maxNum - 1), Math.min(limit + offset, maxNum));
    }
}

