/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.LoadException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.entity.RestBaseResult;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.service.ExecuteEnv;
import org.apache.doris.system.Backend;
import org.apache.doris.system.BeSelectionPolicy;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class LoadAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(LoadAction.class);
    public static final String SUB_LABEL_NAME_PARAM = "sub_label";
    private ExecuteEnv execEnv = ExecuteEnv.getInstance();

    @RequestMapping(path={"/api/{db}/{table}/_load"}, method={RequestMethod.PUT})
    public Object load(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="db") String db, @PathVariable(value="table") String table) {
        if (Config.disable_mini_load) {
            ResponseEntity entity = ResponseEntityBuilder.notFound("The mini load operation has been disabled by default, if you need to add disable_mini_load=false in fe.conf.");
            return entity;
        }
        this.executeCheckPassword(request, response);
        return this.executeWithoutPassword(request, response, db, table, false);
    }

    @RequestMapping(path={"/api/{db}/{table}/_stream_load"}, method={RequestMethod.PUT})
    public Object streamLoad(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="db") String db, @PathVariable(value="table") String table) {
        this.executeCheckPassword(request, response);
        return this.executeWithoutPassword(request, response, db, table, true);
    }

    @RequestMapping(path={"/api/{db}/_stream_load_2pc"}, method={RequestMethod.PUT})
    public Object streamLoad2PC(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="db") String db) {
        this.executeCheckPassword(request, response);
        return this.executeStreamLoad2PC(request, db);
    }

    private Object executeWithoutPassword(HttpServletRequest request, HttpServletResponse response, String db, String table, boolean isStreamLoad) {
        try {
            TNetworkAddress redirectAddr;
            RedirectView redirectView;
            String dbName = db;
            String tableName = table;
            String urlStr = request.getRequestURI();
            if (request.getHeader(HttpHeaderNames.EXPECT.toString()) == null) {
                return new RestBaseResult("There is no 100-continue header");
            }
            String clusterName = ConnectContext.get().getClusterName();
            if (Strings.isNullOrEmpty((String)clusterName)) {
                return new RestBaseResult("No cluster selected.");
            }
            if (Strings.isNullOrEmpty((String)dbName)) {
                return new RestBaseResult("No database selected.");
            }
            if (Strings.isNullOrEmpty((String)tableName)) {
                return new RestBaseResult("No table selected.");
            }
            String fullDbName = ClusterNamespace.getFullName(clusterName, dbName);
            String label = request.getParameter("label");
            if (isStreamLoad) {
                label = request.getHeader("label");
            }
            if (!isStreamLoad && Strings.isNullOrEmpty((String)label)) {
                return new RestBaseResult("No label selected.");
            }
            this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tableName, PrivPredicate.LOAD);
            if (!isStreamLoad && !Strings.isNullOrEmpty((String)request.getParameter(SUB_LABEL_NAME_PARAM))) {
                redirectView = this.redirectToMaster(request, response);
                if (redirectView != null) {
                    return redirectView;
                }
                try {
                    redirectAddr = this.execEnv.getMultiLoadMgr().redirectAddr(fullDbName, label);
                }
                catch (DdlException e) {
                    return new RestBaseResult(e.getMessage());
                }
            } else {
                redirectAddr = this.selectRedirectBackend(clusterName);
            }
            LOG.info("redirect load action to destination={}, stream: {}, db: {}, tbl: {}, label: {}", (Object)redirectAddr.toString(), (Object)isStreamLoad, (Object)dbName, (Object)tableName, (Object)label);
            redirectView = this.redirectTo(request, redirectAddr);
            return redirectView;
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    private Object executeStreamLoad2PC(HttpServletRequest request, String db) {
        try {
            String dbName = db;
            String clusterName = ConnectContext.get().getClusterName();
            if (Strings.isNullOrEmpty((String)clusterName)) {
                return new RestBaseResult("No cluster selected.");
            }
            if (Strings.isNullOrEmpty((String)dbName)) {
                return new RestBaseResult("No database selected.");
            }
            if (Strings.isNullOrEmpty((String)request.getHeader("txn_id"))) {
                return new RestBaseResult("No transaction id selected.");
            }
            String txnOperation = request.getHeader("txn_operation");
            if (Strings.isNullOrEmpty((String)txnOperation)) {
                return new RestBaseResult("No transaction operation('commit' or 'abort') selected.");
            }
            TNetworkAddress redirectAddr = this.selectRedirectBackend(clusterName);
            LOG.info("redirect stream load 2PC action to destination={}, db: {}, txn: {}, operation: {}", (Object)redirectAddr.toString(), (Object)dbName, (Object)request.getHeader("txn_id"), (Object)txnOperation);
            RedirectView redirectView = this.redirectTo(request, redirectAddr);
            return redirectView;
        }
        catch (Exception e) {
            return new RestBaseResult(e.getMessage());
        }
    }

    private TNetworkAddress selectRedirectBackend(String clusterName) throws LoadException {
        BeSelectionPolicy policy = new BeSelectionPolicy.Builder().setCluster(clusterName).needLoadAvailable().build();
        List<Long> backendIds = Catalog.getCurrentSystemInfo().selectBackendIdsByPolicy(policy, 1);
        if (backendIds.isEmpty()) {
            throw new LoadException("No backend load available., policy: " + policy);
        }
        Backend backend = Catalog.getCurrentSystemInfo().getBackend(backendIds.get(0));
        if (backend == null) {
            throw new LoadException("No backend load available., policy: " + policy);
        }
        return new TNetworkAddress(backend.getHost(), backend.getHttpPort());
    }
}

