/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class GetStreamLoadState
extends RestBaseController {
    @RequestMapping(path={"/api/{db}/get_load_state"}, method={RequestMethod.GET})
    public Object execute(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        Database db;
        this.executeCheckPassword(request, response);
        RedirectView redirectView = this.redirectToMaster(request, response);
        if (redirectView != null) {
            return redirectView;
        }
        String label = request.getParameter("label");
        if (Strings.isNullOrEmpty((String)label)) {
            return ResponseEntityBuilder.badRequest("No label selected");
        }
        String fullDbName = this.getFullDbName(dbName);
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        String state = Catalog.getCurrentGlobalTransactionMgr().getLabelState(db.getId(), label).toString();
        return ResponseEntityBuilder.ok(state);
    }
}

