/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.util.SmallFileMgr;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GetSmallFileAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(GetSmallFileAction.class);

    @RequestMapping(path={"/api/get_small_file"}, method={RequestMethod.GET})
    public Object execute(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getParameter("token");
        String fileIdStr = request.getParameter("file_id");
        if (Strings.isNullOrEmpty((String)token) || Strings.isNullOrEmpty((String)fileIdStr)) {
            return ResponseEntityBuilder.badRequest("Missing parameter. Need token and file id");
        }
        if (!token.equals(Catalog.getCurrentCatalog().getToken())) {
            return ResponseEntityBuilder.okWithCommonError("Invalid token");
        }
        long fileId = -1L;
        try {
            fileId = Long.valueOf(fileIdStr);
        }
        catch (NumberFormatException e) {
            return ResponseEntityBuilder.badRequest("Invalid file id format: " + fileIdStr);
        }
        SmallFileMgr fileMgr = Catalog.getCurrentCatalog().getSmallFileMgr();
        SmallFileMgr.SmallFile smallFile = fileMgr.getSmallFile(fileId);
        if (smallFile == null || !smallFile.isContent) {
            return ResponseEntityBuilder.okWithCommonError("File not found or is not content");
        }
        String method = request.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            try {
                this.getFile(request, response, smallFile.getContentBytes(), smallFile.name);
            }
            catch (IOException e) {
                return ResponseEntityBuilder.internalError(e.getMessage());
            }
        }
        return ResponseEntityBuilder.okWithEmpty();
    }
}

