/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.Config;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GetLogFileAction
extends RestBaseController {
    private final Set<String> logFileTypes = Sets.newHashSet((Object[])new String[]{"fe.audit.log"});

    @RequestMapping(path={"/api/get_log_file"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public Object execute(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String logType = request.getParameter("type");
        String logFile = request.getParameter("file");
        if (Strings.isNullOrEmpty((String)logType)) {
            return ResponseEntityBuilder.badRequest("Miss type parameter");
        }
        if (!this.logFileTypes.contains(logType)) {
            return ResponseEntityBuilder.badRequest("log type: " + logType + " is invalid!");
        }
        String method = request.getMethod();
        if (method.equals(RequestMethod.HEAD.name())) {
            String fileInfos = this.getFileInfos(logType);
            response.setHeader("file_infos", fileInfos);
            return ResponseEntityBuilder.ok();
        }
        if (method.equals(RequestMethod.GET.name())) {
            File log = this.getLogFile(logType, logFile);
            if (!log.exists() || !log.isFile()) {
                return ResponseEntityBuilder.okWithCommonError("Log file not exist: " + log.getName());
            }
            if (log != null) {
                try {
                    this.getFile(request, response, log, log.getName());
                }
                catch (IOException e) {
                    return ResponseEntityBuilder.internalError(e.getMessage());
                }
            } else {
                return ResponseEntityBuilder.okWithCommonError("Log file not exist: " + log.getName());
            }
        }
        return ResponseEntityBuilder.ok();
    }

    private String getFileInfos(String logType) {
        TreeMap fileInfos = Maps.newTreeMap();
        if (logType.equals("fe.audit.log")) {
            File logDir = new File(Config.audit_log_dir);
            File[] files = logDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().startsWith("fe.audit.log")) continue;
                fileInfos.put(files[i].getName(), files[i].length());
            }
        }
        String result = "";
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = mapper.writeValueAsString((Object)fileInfos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private File getLogFile(String logType, String logFile) {
        String logPath = "";
        if ("fe.audit.log".equals(logType)) {
            logPath = Config.audit_log_dir + "/" + logFile;
        }
        return new File(logPath);
    }
}

