/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.RestBaseResult;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.load.Load;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class GetLoadInfoAction
extends RestBaseController {
    protected Catalog catalog;

    @RequestMapping(path={"/api/{db}/_load_info"}, method={RequestMethod.GET})
    public Object execute(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.catalog = Catalog.getCurrentCatalog();
        String fullDbName = this.getFullDbName(dbName);
        Load.JobInfo info = new Load.JobInfo(fullDbName, request.getParameter("label"), ConnectContext.get().getClusterName());
        if (Strings.isNullOrEmpty((String)info.dbName)) {
            return new RestBaseResult("No database selected");
        }
        if (Strings.isNullOrEmpty((String)info.label)) {
            return new RestBaseResult("No label selected");
        }
        if (Strings.isNullOrEmpty((String)info.clusterName)) {
            return new RestBaseResult("No cluster selected");
        }
        RedirectView redirectView = this.redirectToMaster(request, response);
        if (redirectView != null) {
            return redirectView;
        }
        try {
            this.catalog.getLoadInstance().getJobInfo(info);
            if (info.tblNames.isEmpty()) {
                this.checkDbAuth(ConnectContext.get().getCurrentUserIdentity(), info.dbName, PrivPredicate.LOAD);
            } else {
                for (String tblName : info.tblNames) {
                    this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), info.dbName, tblName, PrivPredicate.LOAD);
                }
            }
        }
        catch (DdlException | MetaNotFoundException e) {
            try {
                this.catalog.getLoadManager().getLoadJobInfo(info);
            }
            catch (DdlException e1) {
                return new RestBaseResult(e.getMessage());
            }
        }
        return new Result(info);
    }

    private static class Result
    extends RestBaseResult {
        public Load.JobInfo jobInfo;

        public Result(Load.JobInfo info) {
            this.jobInfo = info;
        }
    }
}

