/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GetDdlStmtAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(GetDdlStmtAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/_get_ddl"}, method={RequestMethod.GET})
    public Object execute(HttpServletRequest request, HttpServletResponse response) {
        Object table;
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String dbName = request.getParameter("db");
        String tableName = request.getParameter("table");
        if (Strings.isNullOrEmpty((String)dbName) || Strings.isNullOrEmpty((String)tableName)) {
            return ResponseEntityBuilder.badRequest("Missing params. Need database name and Table name");
        }
        String fullDbName = this.getFullDbName(dbName);
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
            table = db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        ArrayList createTableStmt = Lists.newArrayList();
        ArrayList addPartitionStmt = Lists.newArrayList();
        ArrayList createRollupStmt = Lists.newArrayList();
        ((Table)table).readLock();
        try {
            Catalog.getDdlStmt(table, createTableStmt, addPartitionStmt, createRollupStmt, true, false);
        }
        finally {
            ((Table)table).readUnlock();
        }
        HashMap results = Maps.newHashMap();
        results.put("create_table", createTableStmt);
        results.put("create_partition", addPartitionStmt);
        results.put("create_rollup", createRollupStmt);
        return ResponseEntityBuilder.ok(results);
    }
}

