/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.service.ExecuteEnv;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConnectionAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(ConnectionAction.class);

    @RequestMapping(path={"/api/connection"}, method={RequestMethod.GET})
    protected Object connection(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String connStr = request.getParameter("connection_id");
        if (Strings.isNullOrEmpty((String)connStr)) {
            return ResponseEntityBuilder.badRequest("Missing connection_id");
        }
        int connectionId = -1;
        try {
            connectionId = Integer.valueOf(connStr.trim());
        }
        catch (NumberFormatException e) {
            return ResponseEntityBuilder.badRequest("Invalid connection id: " + e.getMessage());
        }
        ConnectContext context = ExecuteEnv.getInstance().getScheduler().getContext(connectionId);
        if (context == null || context.queryId() == null) {
            return ResponseEntityBuilder.okWithCommonError("connection id " + connectionId + " not found.");
        }
        String queryId = DebugUtil.printId(context.queryId());
        HashMap result = Maps.newHashMap();
        result.put("query_id", queryId);
        return ResponseEntityBuilder.ok(result);
    }
}

