/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.alter.SystemHandler;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CheckDecommissionAction
extends RestBaseController {
    public static final String HOST_PORTS = "host_ports";

    @RequestMapping(path={"/api/check_decommission"}, method={RequestMethod.GET})
    public Object execute(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.OPERATOR);
        String hostPorts = request.getParameter(HOST_PORTS);
        if (Strings.isNullOrEmpty((String)hostPorts)) {
            return ResponseEntityBuilder.badRequest("No host:port specified");
        }
        String[] hostPortArr = hostPorts.split(",");
        if (hostPortArr.length == 0) {
            return ResponseEntityBuilder.badRequest("No host:port specified");
        }
        ArrayList hostPortPairs = Lists.newArrayList();
        for (String hostPort : hostPortArr) {
            Pair<String, Integer> pair;
            try {
                pair = SystemInfoService.validateHostAndPort(hostPort);
            }
            catch (AnalysisException e) {
                return ResponseEntityBuilder.badRequest(e.getMessage());
            }
            hostPortPairs.add(pair);
        }
        try {
            List<Backend> backends = SystemHandler.checkDecommission(hostPortPairs);
            List backendsList = backends.stream().map(b -> b.getHost() + ":" + b.getHeartbeatPort()).collect(Collectors.toList());
            return ResponseEntityBuilder.ok(backendsList);
        }
        catch (DdlException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
    }
}

