/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.exception.UnauthorizedException;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class CancelLoadAction
extends RestBaseController {
    @RequestMapping(path={"/api/{db}/_cancel"}, method={RequestMethod.POST})
    public Object execute(@PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        Database db;
        this.executeCheckPassword(request, response);
        RedirectView redirectView = this.redirectToMaster(request, response);
        if (redirectView != null) {
            return redirectView;
        }
        if (Strings.isNullOrEmpty((String)dbName)) {
            return ResponseEntityBuilder.badRequest("No database selected");
        }
        String fullDbName = this.getFullDbName(dbName);
        String label = request.getParameter("label");
        if (Strings.isNullOrEmpty((String)label)) {
            return ResponseEntityBuilder.badRequest("No label specified");
        }
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), fullDbName, PrivPredicate.LOAD)) {
            throw new UnauthorizedException("Access denied for user '" + ConnectContext.get().getQualifiedUser() + "' to database '" + fullDbName + "'");
        }
        try {
            Catalog.getCurrentGlobalTransactionMgr().abortTransaction((Long)db.getId(), label, "user cancel");
        }
        catch (UserException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        return ResponseEntityBuilder.ok();
    }
}

