/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BootstrapFinishAction {
    private static final String CLUSTER_ID = "cluster_id";
    private static final String TOKEN = "token";
    public static final String REPLAYED_JOURNAL_ID = "replayedJournalId";
    public static final String QUERY_PORT = "queryPort";
    public static final String RPC_PORT = "rpcPort";
    public static final String VERSION = "version";

    @RequestMapping(path={"/api/bootstrap"}, method={RequestMethod.GET})
    public ResponseEntity execute(HttpServletRequest request, HttpServletResponse response) {
        boolean isReady = Catalog.getCurrentCatalog().isReady();
        BootstrapResult result = new BootstrapResult();
        if (isReady) {
            String clusterIdStr = request.getParameter(CLUSTER_ID);
            String token = request.getParameter(TOKEN);
            if (!Strings.isNullOrEmpty((String)clusterIdStr) && !Strings.isNullOrEmpty((String)token)) {
                int clusterId = 0;
                try {
                    clusterId = Integer.valueOf(clusterIdStr);
                }
                catch (NumberFormatException e) {
                    return ResponseEntityBuilder.badRequest("invalid cluster id format: " + clusterIdStr);
                }
                if (clusterId != Catalog.getCurrentCatalog().getClusterId()) {
                    return ResponseEntityBuilder.okWithCommonError("invalid cluster id: " + clusterId);
                }
                if (!token.equals(Catalog.getCurrentCatalog().getToken())) {
                    return ResponseEntityBuilder.okWithCommonError("invalid token: " + token);
                }
                long replayedJournalId = Catalog.getCurrentCatalog().getReplayedJournalId();
                result.setReplayedJournalId(replayedJournalId);
                result.setQueryPort(Config.query_port);
                result.setRpcPort(Config.rpc_port);
                result.setVersion("1.1.0-rc05-Unknown");
            }
            return ResponseEntityBuilder.ok(result);
        }
        return ResponseEntityBuilder.okWithCommonError("not ready");
    }

    private static class BootstrapResult {
        private long replayedJournalId = 0L;
        private int queryPort = 0;
        private int rpcPort = 0;
        private String version = "";

        public void setReplayedJournalId(long replayedJournalId) {
            this.replayedJournalId = replayedJournalId;
        }

        public long getReplayedJournalId() {
            return this.replayedJournalId;
        }

        public void setQueryPort(int queryPort) {
            this.queryPort = queryPort;
        }

        public int getQueryPort() {
            return this.queryPort;
        }

        public void setRpcPort(int rpcPort) {
            this.rpcPort = rpcPort;
        }

        public int getRpcPort() {
            return this.rpcPort;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

