/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.system.Backend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BackendsAction
extends RestBaseController {
    public static final Logger LOG = LogManager.getLogger(BackendsAction.class);
    private static final String IS_ALIVE = "is_alive";

    @RequestMapping(path={"/api/backends"}, method={RequestMethod.GET})
    public Object getBackends(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        boolean needAlive = false;
        String isAlive = request.getParameter(IS_ALIVE);
        if (!Strings.isNullOrEmpty((String)isAlive) && isAlive.equalsIgnoreCase("true")) {
            needAlive = true;
        }
        BackendInfo backendInfo = new BackendInfo();
        backendInfo.backends = Lists.newArrayList();
        List<Long> beIds = Catalog.getCurrentSystemInfo().getBackendIds(needAlive);
        for (Long beId : beIds) {
            Backend be = Catalog.getCurrentSystemInfo().getBackend(beId);
            if (be == null) continue;
            BackendRow backendRow = new BackendRow();
            backendRow.ip = be.getHost();
            backendRow.httpPort = be.getHttpPort();
            backendRow.isAlive = be.isAlive();
            backendInfo.backends.add(backendRow);
        }
        return ResponseEntityBuilder.ok(backendInfo);
    }

    public static class BackendRow {
        @JsonProperty(value="ip")
        public String ip;
        @JsonProperty(value="http_port")
        public int httpPort;
        @JsonProperty(value="is_alive")
        public boolean isAlive;

        public String getIp() {
            return this.ip;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        @JsonProperty(value="ip")
        public void setIp(String ip) {
            this.ip = ip;
        }

        @JsonProperty(value="http_port")
        public void setHttpPort(int httpPort) {
            this.httpPort = httpPort;
        }

        @JsonProperty(value="is_alive")
        public void setAlive(boolean isAlive) {
            this.isAlive = isAlive;
        }
    }

    public static class BackendInfo {
        @JsonProperty(value="backends")
        public List<BackendRow> backends;

        public List<BackendRow> getBackends() {
            return this.backends;
        }

        @JsonProperty(value="backends")
        public void setBackends(List<BackendRow> backends) {
            this.backends = backends;
        }
    }
}

