/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.meta;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.meta.InvalidClientException;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.master.MetaHelper;
import org.apache.doris.persist.MetaCleaner;
import org.apache.doris.persist.Storage;
import org.apache.doris.persist.StorageInfo;
import org.apache.doris.system.Frontend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaService
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(MetaService.class);
    private static final int TIMEOUT_SECOND = 10;
    private static final String VERSION = "version";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private File imageDir = MetaHelper.getMasterImageDir();

    private boolean isFromValidFe(HttpServletRequest request) {
        String clientHost = request.getRemoteHost();
        Frontend fe = Catalog.getCurrentCatalog().getFeByHost(clientHost);
        if (fe == null) {
            LOG.warn("request is not from valid FE. client: {}", (Object)clientHost);
            return false;
        }
        return true;
    }

    private void checkFromValidFe(HttpServletRequest request) throws InvalidClientException {
        if (!this.isFromValidFe(request)) {
            throw new InvalidClientException("invalid client host: " + request.getRemoteHost());
        }
    }

    @RequestMapping(path={"/image"}, method={RequestMethod.GET})
    public Object image(HttpServletRequest request, HttpServletResponse response) {
        this.checkFromValidFe(request);
        String versionStr = request.getParameter(VERSION);
        if (Strings.isNullOrEmpty((String)versionStr)) {
            return ResponseEntityBuilder.badRequest("Miss version parameter");
        }
        long version = this.checkLongParam(versionStr);
        if (version < 0L) {
            return ResponseEntityBuilder.badRequest("The version number cannot be less than 0");
        }
        File imageFile = Storage.getImageFile(this.imageDir, version);
        if (!imageFile.exists()) {
            return ResponseEntityBuilder.notFound("image file not found");
        }
        try {
            this.writeFileResponse(request, response, imageFile);
            return null;
        }
        catch (IOException e) {
            return ResponseEntityBuilder.internalError(e.getMessage());
        }
    }

    @RequestMapping(path={"/info"}, method={RequestMethod.GET})
    public Object info(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.checkFromValidFe(request);
        try {
            Storage currentStorageInfo = new Storage(this.imageDir.getAbsolutePath());
            StorageInfo storageInfo = new StorageInfo(currentStorageInfo.getClusterID(), currentStorageInfo.getLatestImageSeq(), currentStorageInfo.getEditsSeq());
            return ResponseEntityBuilder.ok(storageInfo);
        }
        catch (IOException e) {
            return ResponseEntityBuilder.internalError(e.getMessage());
        }
    }

    @RequestMapping(path={"/version"}, method={RequestMethod.GET})
    public void version(HttpServletRequest request, HttpServletResponse response) throws IOException, DdlException {
        this.checkFromValidFe(request);
        File versionFile = new File(this.imageDir, "VERSION");
        this.writeFileResponse(request, response, versionFile);
    }

    @RequestMapping(path={"/put"}, method={RequestMethod.GET})
    public Object put(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.checkFromValidFe(request);
        String portStr = request.getParameter(PORT);
        if (Strings.isNullOrEmpty((String)portStr)) {
            return ResponseEntityBuilder.badRequest("Port number cannot be empty");
        }
        int port = Integer.parseInt(portStr);
        if (port < 0 || port > 65535) {
            return ResponseEntityBuilder.badRequest("port is invalid. The port number is between 0-65535");
        }
        String versionStr = request.getParameter(VERSION);
        if (Strings.isNullOrEmpty((String)versionStr)) {
            return ResponseEntityBuilder.badRequest("Miss version parameter");
        }
        this.checkLongParam(versionStr);
        String machine = request.getRemoteHost();
        String url = "http://" + machine + ":" + port + "/image?version=" + versionStr;
        String filename = "image." + versionStr;
        File dir = new File(Catalog.getCurrentCatalog().getImageDir());
        try {
            OutputStream out = MetaHelper.getOutputStream(filename, dir);
            MetaHelper.getRemoteFile(url, 10000, out);
            MetaHelper.complete(filename, dir);
        }
        catch (FileNotFoundException e) {
            return ResponseEntityBuilder.notFound("file not found.");
        }
        catch (IOException e) {
            LOG.warn("failed to get remote file. url: {}", (Object)url, (Object)e);
            return ResponseEntityBuilder.internalError("failed to get remote file: " + e.getMessage());
        }
        try {
            MetaCleaner cleaner = new MetaCleaner(Config.meta_dir + "/image");
            cleaner.clean();
        }
        catch (Exception e) {
            LOG.error("Follower/Observer delete old image file fail.", (Throwable)e);
        }
        return ResponseEntityBuilder.ok();
    }

    @RequestMapping(path={"/journal_id"}, method={RequestMethod.GET})
    public Object journal_id(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.checkFromValidFe(request);
        long id = Catalog.getCurrentCatalog().getReplayedJournalId();
        response.setHeader("id", Long.toString(id));
        return ResponseEntityBuilder.ok();
    }

    @RequestMapping(path={"/role"}, method={RequestMethod.GET})
    public Object role(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.checkFromValidFe(request);
        String host = request.getParameter(HOST);
        String portString = request.getParameter(PORT);
        if (!Strings.isNullOrEmpty((String)host) && !Strings.isNullOrEmpty((String)portString)) {
            int port = Integer.parseInt(portString);
            Frontend fe = Catalog.getCurrentCatalog().checkFeExist(host, port);
            if (fe == null) {
                response.setHeader("role", FrontendNodeType.UNKNOWN.name());
            } else {
                response.setHeader("role", fe.getRole().name());
                response.setHeader("name", fe.getNodeName());
            }
            return ResponseEntityBuilder.ok();
        }
        return ResponseEntityBuilder.badRequest("Miss parameter");
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.GET})
    public Object check(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.checkFromValidFe(request);
        try {
            Storage storage = new Storage(this.imageDir.getAbsolutePath());
            response.setHeader("cluster_id", Integer.toString(storage.getClusterID()));
            response.setHeader("token", storage.getToken());
        }
        catch (IOException e) {
            return ResponseEntityBuilder.internalError(e.getMessage());
        }
        return ResponseEntityBuilder.ok();
    }

    @RequestMapping(value={"/dump"}, method={RequestMethod.GET})
    public Object dump(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        String dumpFilePath = Catalog.getCurrentCatalog().dumpImage();
        if (dumpFilePath == null) {
            return ResponseEntityBuilder.okWithCommonError("dump failed.");
        }
        HashMap res = Maps.newHashMap();
        res.put("dumpFilePath", dumpFilePath);
        return ResponseEntityBuilder.ok(res);
    }
}

