/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.meta;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateGroupSchema;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.common.DdlException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class ColocateMetaService
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(ColocateMetaService.class);
    private static final String GROUP_ID = "group_id";
    private static final String DB_ID = "db_id";
    private static ColocateTableIndex colocateIndex = Catalog.getCurrentColocateIndex();

    private static ColocateTableIndex.GroupId checkAndGetGroupId(HttpServletRequest request) throws DdlException {
        long grpId = Long.valueOf(request.getParameter(GROUP_ID).trim());
        long dbId = Long.valueOf(request.getParameter(DB_ID).trim());
        ColocateTableIndex.GroupId groupId = new ColocateTableIndex.GroupId(dbId, grpId);
        if (!colocateIndex.isGroupExist(groupId)) {
            throw new DdlException("the group " + groupId + "isn't  exist");
        }
        return groupId;
    }

    public Object executeWithoutPassword(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.executeCheckPassword(request, response);
        RedirectView redirectView = this.redirectToMaster(request, response);
        if (redirectView != null) {
            return redirectView;
        }
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        return null;
    }

    @RequestMapping(path={"/api/colocate"}, method={RequestMethod.GET})
    public Object colocate(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.executeWithoutPassword(request, response);
        return ResponseEntityBuilder.ok(Catalog.getCurrentColocateIndex());
    }

    @RequestMapping(path={"/api/colocate/group_stable"}, method={RequestMethod.POST, RequestMethod.DELETE})
    public Object group_stable(HttpServletRequest request, HttpServletResponse response) throws DdlException {
        this.executeWithoutPassword(request, response);
        ColocateTableIndex.GroupId groupId = ColocateMetaService.checkAndGetGroupId(request);
        String method = request.getMethod();
        if ("POST".equalsIgnoreCase(method)) {
            colocateIndex.markGroupUnstable(groupId, "mark unstable via http api", true);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            colocateIndex.markGroupStable(groupId, true);
        }
        return ResponseEntityBuilder.ok();
    }

    @RequestMapping(path={"/api/colocate/bucketseq"}, method={RequestMethod.POST})
    public Object bucketseq(HttpServletRequest request, HttpServletResponse response, @RequestBody String meta) throws DdlException {
        this.executeWithoutPassword(request, response);
        String clusterName = ConnectContext.get().getClusterName();
        ColocateTableIndex.GroupId groupId = ColocateMetaService.checkAndGetGroupId(request);
        Type type = new TypeToken<List<List<Long>>>(){}.getType();
        List backendsPerBucketSeq = (List)new Gson().fromJson(meta, type);
        LOG.info("get buckets sequence: {}", (Object)backendsPerBucketSeq);
        ColocateGroupSchema groupSchema = Catalog.getCurrentColocateIndex().getGroupSchema(groupId);
        if (backendsPerBucketSeq.size() != groupSchema.getBucketsNum()) {
            return ResponseEntityBuilder.okWithCommonError("Invalid bucket num. expected: " + groupSchema.getBucketsNum() + ", actual: " + backendsPerBucketSeq.size());
        }
        List<Long> clusterBackendIds = Catalog.getCurrentSystemInfo().getClusterBackendIds(clusterName, true);
        for (List backendIds : backendsPerBucketSeq) {
            if (backendIds.size() != groupSchema.getReplicaAlloc().getTotalReplicaNum()) {
                return ResponseEntityBuilder.okWithCommonError("Invalid backend num per bucket. expected: " + groupSchema.getReplicaAlloc().getTotalReplicaNum() + ", actual: " + backendIds.size());
            }
            for (Long beId : backendIds) {
                if (clusterBackendIds.contains(beId)) continue;
                return ResponseEntityBuilder.okWithCommonError("The backend " + beId + " does not exist or not available");
            }
        }
        int bucketsNum = colocateIndex.getBackendsPerBucketSeq(groupId).size();
        Preconditions.checkState((backendsPerBucketSeq.size() == bucketsNum ? 1 : 0) != 0, (Object)(backendsPerBucketSeq.size() + " vs. " + bucketsNum));
        this.updateBackendPerBucketSeq(groupId, backendsPerBucketSeq);
        LOG.info("the group {} backendsPerBucketSeq meta has been changed to {}", (Object)groupId, (Object)backendsPerBucketSeq);
        return ResponseEntityBuilder.ok();
    }

    private void updateBackendPerBucketSeq(ColocateTableIndex.GroupId groupId, List<List<Long>> backendsPerBucketSeq) throws DdlException {
        throw new DdlException("Currently not support");
    }
}

