/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.interceptor;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebFilter(urlPatterns={"/*"}, filterName="traceIterceptor")
public class ServletTraceIterceptor
implements Filter {
    private static final Logger LOG = LogManager.getLogger(ServletTraceIterceptor.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("TRACE".equalsIgnoreCase(httpRequest.getMethod())) {
            httpResponse.setStatus(405);
            LOG.warn("Trace method is not allowed to be called, has been intercepted, IP address:" + request.getRemoteAddr());
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

