/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.exception;

import org.apache.doris.common.UserException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.exception.BadRequestException;
import org.apache.doris.httpv2.exception.UnauthorizedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class RestApiExceptionHandler {
    private static final Logger LOG = LogManager.getLogger(RestApiExceptionHandler.class);

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    public Object unauthorizedHandler(UnauthorizedException e) {
        LOG.debug("unauthorized exception", (Throwable)e);
        return ResponseEntityBuilder.unauthorized(e.getMessage());
    }

    @ExceptionHandler(value={UserException.class})
    @ResponseBody
    public Object userExceptionHandler(UserException e) {
        LOG.debug("user exception", (Throwable)e);
        return ResponseEntityBuilder.ok(e.getMessage());
    }

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseBody
    public Object badRequestExceptionHandler(BadRequestException e) {
        LOG.debug("bad request exception", (Throwable)e);
        return ResponseEntityBuilder.badRequest(e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object unexpectedExceptionHandler(Exception e) {
        LOG.debug("unexpected exception", (Throwable)e);
        return ResponseEntityBuilder.internalError(e.getMessage());
    }
}

