/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.httpv2.controller.BaseController;
import org.apache.doris.httpv2.entity.ResponseBody;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.MasterOpExecutor;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.ShowResultSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1"})
public class SystemController
extends BaseController {
    private static final Logger LOG = LogManager.getLogger(SystemController.class);

    @RequestMapping(path={"/system"}, method={RequestMethod.GET})
    public Object system(HttpServletRequest request) {
        String currentPath = request.getParameter("path");
        if (Strings.isNullOrEmpty((String)currentPath)) {
            currentPath = "/";
        }
        LOG.debug("get /system request, thread id: {}", (Object)Thread.currentThread().getId());
        ResponseEntity entity = this.appendSystemInfo(currentPath, currentPath, request);
        return entity;
    }

    protected ProcNodeInterface getProcNode(String path) {
        ProcNodeInterface node;
        ProcService instance = ProcService.getInstance();
        try {
            node = Strings.isNullOrEmpty((String)path) ? instance.open("/") : instance.open(path);
        }
        catch (AnalysisException e) {
            LOG.warn(e.getMessage());
            return null;
        }
        return node;
    }

    private ResponseEntity appendSystemInfo(String procPath, String path, HttpServletRequest request) {
        Object result;
        UrlValidator validator = new UrlValidator();
        HashMap map = new HashMap();
        ProcNodeInterface procNode = this.getProcNode(procPath);
        if (procNode == null) {
            return ResponseEntityBuilder.notFound("No such proc path[" + path + "]");
        }
        boolean isDir = procNode instanceof ProcDirInterface;
        List<String> columnNames = null;
        List<List<String>> rows = null;
        if (!Catalog.getCurrentCatalog().isMaster()) {
            String showProcStmt = "SHOW PROC \"" + procPath + "\"";
            MasterOpExecutor masterOpExecutor = new MasterOpExecutor(new OriginStatement(showProcStmt, 0), ConnectContext.get(), RedirectStatus.FORWARD_NO_SYNC, true);
            try {
                masterOpExecutor.execute();
            }
            catch (Exception e) {
                LOG.warn("Fail to forward. ", (Throwable)e);
                return ResponseEntityBuilder.internalError("Failed to forward request to master: " + e.getMessage());
            }
            ShowResultSet resultSet = masterOpExecutor.getProxyResultSet();
            if (resultSet == null) {
                return ResponseEntityBuilder.internalError("Failed to get result from master");
            }
            columnNames = resultSet.getMetaData().getColumns().stream().map(c -> c.getName()).collect(Collectors.toList());
            rows = resultSet.getResultRows();
        } else {
            try {
                result = procNode.fetchResult();
            }
            catch (AnalysisException e) {
                return ResponseEntityBuilder.internalError("The result is null.Maybe haven't be implemented completely[" + e.getMessage() + "], please check.INFO: ProcNode type is [" + procNode.getClass().getName() + "]: " + e.getMessage());
            }
            columnNames = result.getColumnNames();
            rows = result.getRows();
        }
        Preconditions.checkNotNull(columnNames);
        Preconditions.checkNotNull(rows);
        result = Maps.newHashMap();
        result.put("column_names", columnNames);
        ArrayList hrefColumns = Lists.newArrayList();
        if (isDir) {
            hrefColumns.add(columnNames.get(0));
        }
        ArrayList list = Lists.newArrayList();
        for (List<String> strList : rows) {
            HashMap<String, Object> rowColumns = new HashMap<String, Object>();
            ArrayList hrefPaths = Lists.newArrayList();
            for (int i = 0; i < strList.size(); ++i) {
                String str = strList.get(i);
                if (isDir && i == 0) {
                    String escapeStr = str.replace("%", "%25");
                    String uriPath = "path=" + path + "/" + escapeStr;
                    hrefPaths.add("/rest/v1/system?" + uriPath);
                } else if (validator.isValid(str)) {
                    hrefPaths.add(str);
                    str = "URL";
                    if (!hrefColumns.contains(columnNames.get(i))) {
                        hrefColumns.add(columnNames.get(i));
                    }
                }
                rowColumns.put(columnNames.get(i), str);
            }
            if (!hrefPaths.isEmpty()) {
                rowColumns.put("__hrefPaths", hrefPaths);
            }
            list.add(rowColumns);
        }
        result.put("rows", list);
        if (!hrefColumns.isEmpty()) {
            result.put("href_columns", hrefColumns);
        }
        result.put("parent_url", this.getParentUrl(path));
        ResponseEntity entity = ResponseEntityBuilder.ok(result);
        ((ResponseBody)entity.getBody()).setCount(list.size());
        return entity;
    }

    private String getParentUrl(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        if ((path = path.getParent()) == null) {
            return "/rest/v1/system";
        }
        return "/rest/v1/system?path=" + path.toString();
    }
}

