/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.httpv2.controller.BaseController;
import org.apache.doris.httpv2.entity.ResponseBody;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.service.ExecuteEnv;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1"})
public class SessionController
extends BaseController {
    private static final List<String> SESSION_TABLE_HEADER = Lists.newArrayList();

    @RequestMapping(path={"/session"}, method={RequestMethod.GET})
    public Object session() {
        HashMap result = Maps.newHashMap();
        this.appendSessionInfo(result);
        ResponseEntity entity = ResponseEntityBuilder.ok(result);
        ((ResponseBody)entity.getBody()).setCount(result.size());
        return entity;
    }

    private void appendSessionInfo(Map<String, Object> result) {
        List<ConnectContext.ThreadInfo> threadInfos = ExecuteEnv.getInstance().getScheduler().listConnection("root");
        ArrayList rows = Lists.newArrayList();
        result.put("column_names", SESSION_TABLE_HEADER);
        ArrayList list = Lists.newArrayList();
        result.put("rows", list);
        long nowMs = System.currentTimeMillis();
        for (ConnectContext.ThreadInfo info : threadInfos) {
            rows.add(info.toRow(nowMs));
        }
        for (List row : rows) {
            HashMap<String, String> record = new HashMap<String, String>();
            for (int i = 0; i < row.size(); ++i) {
                record.put(SESSION_TABLE_HEADER.get(i), (String)row.get(i));
            }
            list.add(record);
        }
    }

    static {
        SESSION_TABLE_HEADER.add("Id");
        SESSION_TABLE_HEADER.add("User");
        SESSION_TABLE_HEADER.add("Host");
        SESSION_TABLE_HEADER.add("Cluster");
        SESSION_TABLE_HEADER.add("Db");
        SESSION_TABLE_HEADER.add("Command");
        SESSION_TABLE_HEADER.add("Time");
        SESSION_TABLE_HEADER.add("State");
        SESSION_TABLE_HEADER.add("Info");
    }
}

