/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.httpv2.controller.BaseController;
import org.apache.doris.httpv2.entity.ResponseBody;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1"})
public class QueryProfileController
extends BaseController {
    private static final Logger LOG = LogManager.getLogger(QueryProfileController.class);
    private static final String QUERY_ID = "query_id";

    @RequestMapping(path={"/query_profile/{query_id}"}, method={RequestMethod.GET})
    public Object profile(@PathVariable(value="query_id") String queryId) {
        String profile = ProfileManager.getInstance().getProfile(queryId);
        if (profile == null) {
            return ResponseEntityBuilder.okWithCommonError("Query " + queryId + " does not exist");
        }
        profile = profile.replaceAll("\n", "</br>");
        profile = profile.replaceAll(" ", "&nbsp;&nbsp;");
        return ResponseEntityBuilder.ok(profile);
    }

    @RequestMapping(path={"/query_profile"}, method={RequestMethod.GET})
    public Object query() {
        HashMap result = Maps.newHashMap();
        this.addFinishedQueryInfo(result);
        ResponseEntity entity = ResponseEntityBuilder.ok(result);
        ((ResponseBody)entity.getBody()).setCount(result.size());
        return entity;
    }

    private void addFinishedQueryInfo(Map<String, Object> result) {
        List<List<String>> finishedQueries = ProfileManager.getInstance().getAllQueries();
        ArrayList<String> columnHeaders = ProfileManager.PROFILE_HEADERS;
        int queryIdIndex = 0;
        for (int i = 0; i < columnHeaders.size(); ++i) {
            if (!((String)columnHeaders.get(i)).equals("Query ID")) continue;
            queryIdIndex = i;
            break;
        }
        result.put("column_names", columnHeaders);
        result.put("href_column", Lists.newArrayList((Object[])new String[]{"Query ID"}));
        ArrayList list = Lists.newArrayList();
        result.put("rows", list);
        for (List<String> row : finishedQueries) {
            String queryId = row.get(queryIdIndex);
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (int i = 0; i < row.size(); ++i) {
                rowMap.put((String)columnHeaders.get(i), row.get(i));
            }
            if (Strings.isNullOrEmpty((String)queryId)) {
                rowMap.put("__hrefPaths", Lists.newArrayList((Object[])new String[]{"/query_profile/-1"}));
            } else {
                rowMap.put("__hrefPaths", Lists.newArrayList((Object[])new String[]{"/query_profile/" + queryId}));
            }
            list.add(rowMap);
        }
    }
}

