/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.Config;
import org.apache.doris.common.Log4jConfig;
import org.apache.doris.httpv2.config.ReadEnvironment;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1"})
public class LogController {
    private static final Logger LOG = LogManager.getLogger(LogController.class);
    private static long WEB_LOG_BYTES = 0x100000L;
    private String addVerboseName;
    private String delVerboseName;
    @Autowired
    private ReadEnvironment readEnvironment;

    @RequestMapping(path={"/log"}, method={RequestMethod.GET})
    public Object log(HttpServletRequest request) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        this.appendLogConf(map);
        this.appendLogInfo(map);
        return ResponseEntityBuilder.ok(map);
    }

    @RequestMapping(path={"/log"}, method={RequestMethod.POST})
    public Object logLevel(HttpServletRequest request) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        this.addVerboseName = request.getParameter("add_verbose");
        this.delVerboseName = request.getParameter("del_verbose");
        LOG.info("add verbose name: {}, del verbose name: {}", (Object)this.addVerboseName, (Object)this.delVerboseName);
        this.appendLogConf(map);
        return ResponseEntityBuilder.ok(map);
    }

    private void appendLogConf(Map<String, Map<String, String>> content) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList verboseNames;
            Log4jConfig.Tuple<String, String[], String[]> configs = Log4jConfig.updateLogging(null, null, null);
            if (!Strings.isNullOrEmpty((String)this.addVerboseName)) {
                this.addVerboseName = this.addVerboseName.trim();
                verboseNames = Lists.newArrayList((Object[])((String[])configs.y));
                if (!verboseNames.contains(this.addVerboseName)) {
                    verboseNames.add(this.addVerboseName);
                    configs = Log4jConfig.updateLogging(null, verboseNames.toArray(new String[verboseNames.size()]), null);
                    this.readEnvironment.reinitializeLoggingSystem();
                }
            }
            if (!Strings.isNullOrEmpty((String)this.delVerboseName)) {
                this.delVerboseName = this.delVerboseName.trim();
                verboseNames = Lists.newArrayList((Object[])((String[])configs.y));
                if (verboseNames.contains(this.delVerboseName)) {
                    verboseNames.remove(this.delVerboseName);
                    configs = Log4jConfig.updateLogging(null, verboseNames.toArray(new String[verboseNames.size()]), null);
                    this.readEnvironment.reinitializeLoggingSystem();
                }
            }
            map.put("Level", (String)configs.x);
            map.put("VerboseNames", StringUtils.join((Object[])((Object[])configs.y), (String)","));
            map.put("AuditNames", StringUtils.join((Object[])((Object[])configs.z), (String)","));
            content.put("LogConfiguration", map);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLogInfo(Map<String, Map<String, String>> content) {
        HashMap<String, String> map = new HashMap<String, String>();
        String logPath = Config.sys_log_dir + "/fe.warn.log";
        map.put("logPath", logPath);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(logPath, "r");
            long fileSize = raf.length();
            long startPos = fileSize < WEB_LOG_BYTES ? 0L : fileSize - WEB_LOG_BYTES;
            long webContentLength = fileSize < WEB_LOG_BYTES ? fileSize : WEB_LOG_BYTES;
            raf.seek(startPos);
            map.put("showingLast", webContentLength + " bytes of log");
            StringBuilder sb = new StringBuilder();
            String line = "";
            sb.append("<pre>");
            while ((line = raf.readLine()) != null) {
                sb.append(line).append("</br>");
            }
            sb.append("</pre>");
            map.put("log", sb.toString());
        }
        catch (FileNotFoundException e) {
            map.put("error", "Couldn't open log file: " + logPath);
        }
        catch (IOException e) {
            map.put("error", "Failed to read log file: " + logPath);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e) {
                LOG.warn("fail to close log file: " + logPath, (Throwable)e);
            }
        }
        content.put("LogContents", map);
    }
}

