/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.qe.HelpModule;
import org.apache.doris.qe.HelpTopic;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1"})
public class HelpController {
    private String queryString = null;

    @RequestMapping(path={"/help"}, method={RequestMethod.GET})
    public Object helpSearch(HttpServletRequest request) {
        this.queryString = request.getParameter("query");
        this.queryString = Strings.isNullOrEmpty((String)this.queryString) ? "contents" : this.queryString.trim();
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.appendHelpInfo(result);
        return ResponseEntityBuilder.ok(result);
    }

    private void appendHelpInfo(Map<String, Object> result) {
        this.appendExactMatchTopic(result);
        this.appendFuzzyMatchTopic(result);
        this.appendCategories(result);
    }

    private void appendExactMatchTopic(Map<String, Object> result) {
        HelpModule module = HelpModule.getInstance();
        HelpTopic topic = module.getTopic(this.queryString);
        if (topic == null) {
            result.put("matching", "No Exact Matching Topic.");
        } else {
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            this.appendOneTopicInfo(subMap, topic, "matching");
            result.put("matchingTopic", subMap);
        }
    }

    private void appendFuzzyMatchTopic(Map<String, Object> result) {
        HelpModule module = HelpModule.getInstance();
        List<String> topics = module.listTopicByKeyword(this.queryString);
        if (topics.isEmpty()) {
            result.put("fuzzy", "No Fuzzy Matching Topic");
        } else if (topics.size() == 1) {
            result.put("fuzzy", "Find only one topic, show you the detail info below");
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            this.appendOneTopicInfo(subMap, module.getTopic(topics.get(0)), "fuzzy");
            result.put("fuzzyTopic", subMap);
        } else {
            result.put("size", topics.size());
            result.put("datas", topics);
        }
    }

    private void appendCategories(Map<String, Object> result) {
        HelpModule module = HelpModule.getInstance();
        List<String> categories = module.listCategoryByName(this.queryString);
        if (categories.isEmpty()) {
            result.put("matching", "No Matching Category");
        } else if (categories.size() == 1) {
            List<String> subCategories;
            result.put("matching", "Find only one category, so show you the detail info below");
            List<String> topics = module.listTopicByCategory(categories.get(0));
            if (topics.size() > 0) {
                ArrayList topic_list = new ArrayList();
                result.put("topicSize", topics.size());
                for (String string : topics) {
                    HashMap<String, String> top = new HashMap<String, String>();
                    top.put("name", string);
                    topic_list.add(top);
                }
                result.put("topicdatas", topic_list);
            }
            if ((subCategories = module.listCategoryByCategory(categories.get(0))).size() > 0) {
                ArrayList subCate = new ArrayList();
                result.put("subCateSize", subCategories.size());
                for (String sub : subCategories) {
                    HashMap<String, String> subMap = new HashMap<String, String>();
                    subMap.put("name", sub);
                    subCate.add(subMap);
                }
                result.put("subdatas", subCate);
            }
        } else {
            ArrayList category_list = new ArrayList();
            if (categories.size() > 0) {
                result.put("categoriesSize", categories.size());
                for (String cate : categories) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("name", cate);
                    category_list.add(hashMap);
                }
                result.put("categoryDatas", category_list);
            }
        }
    }

    private void appendOneTopicInfo(Map<String, Object> result, HelpTopic topic, String prefix) {
        result.put(prefix + "topic", this.escapeHtmlInPreTag(topic.getName()));
        result.put(prefix + "description", this.escapeHtmlInPreTag(topic.getDescription()));
        result.put(prefix + "example", this.escapeHtmlInPreTag(topic.getExample()));
        result.put(prefix + "Keyword", this.escapeHtmlInPreTag(topic.getKeywords().toString()));
        result.put(prefix + "Url", this.escapeHtmlInPreTag(topic.getUrl()));
    }

    protected String escapeHtmlInPreTag(String oriStr) {
        if (oriStr == null) {
            return "";
        }
        String content = oriStr.replaceAll("\n", "</br>");
        return content;
    }
}

