/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

@RestController
@RequestMapping(value={"/rest/v1"})
public class HardwareInfoController {
    @RequestMapping(path={"/hardware_info/fe"}, method={RequestMethod.GET})
    public Object index() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        this.appendVersionInfo(map);
        this.appendHardwareInfo(map);
        return ResponseEntityBuilder.ok(map);
    }

    private void appendVersionInfo(Map<String, Map<String, String>> content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Version", "1.1.0-rc05");
        map.put("Git", "file:///root/doris@Unknown");
        map.put("BuildInfo", "root@1264bad10c91");
        map.put("BuildTime", "Sun, 10 Jul 2022 13:58:03 UTC");
        content.put("VersionInfo", map);
    }

    private void appendHardwareInfo(Map<String, Map<String, String>> content) {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        HardwareAbstractionLayer hal = si.getHardware();
        CentralProcessor processor = hal.getProcessor();
        GlobalMemory memory = hal.getMemory();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("OS", String.join((CharSequence)"<br>", this.getOperatingSystem(os)));
        map.put("Processor", String.join((CharSequence)"<br>", this.getProcessor(processor)));
        map.put("Memory", String.join((CharSequence)"<br>", this.getMemory(memory)));
        map.put("Processes", String.join((CharSequence)"<br>", this.getProcesses(os, memory)));
        map.put("Disk", String.join((CharSequence)"<br>", this.getDisks(hal.getDiskStores())));
        map.put("FileSystem", String.join((CharSequence)"<br>", this.getFileSystem(os.getFileSystem())));
        map.put("NetworkInterface", String.join((CharSequence)"<br>", this.getNetworkInterfaces(hal.getNetworkIFs())));
        map.put("NetworkParameter", String.join((CharSequence)"<br>", this.getNetworkParameters(os.getNetworkParams())));
        content.put("HardwareInfo", map);
    }

    private List<String> getOperatingSystem(OperatingSystem os) {
        ArrayList<String> osInfo = new ArrayList<String>();
        osInfo.add(String.valueOf(os));
        osInfo.add("Booted: " + Instant.ofEpochSecond(os.getSystemBootTime()));
        osInfo.add("Uptime: " + FormatUtil.formatElapsedSecs((long)os.getSystemUptime()));
        osInfo.add("Running with" + (os.isElevated() ? "" : "out") + " elevated permissions.");
        return osInfo;
    }

    private List<String> getProcessor(CentralProcessor processor) {
        long[] freqs;
        double[] load;
        ArrayList<String> processorInfo = new ArrayList<String>();
        processorInfo.add(String.valueOf(processor));
        processorInfo.add(" " + processor.getPhysicalPackageCount() + " physical CPU package(s)");
        processorInfo.add(" " + processor.getPhysicalProcessorCount() + " physical CPU core(s)");
        processorInfo.add(" " + processor.getLogicalProcessorCount() + " logical CPU(s)");
        processorInfo.add("Identifier:&nbsp;&nbsp; " + processor.getIdentifier());
        processorInfo.add("ProcessorID:&nbsp;&nbsp; " + processor.getProcessorID());
        processorInfo.add("Context Switches/Interrupts:&nbsp;&nbsp; " + processor.getContextSwitches() + " / " + processor.getInterrupts() + "<br>");
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        long[][] prevProcTicks = processor.getProcessorCpuLoadTicks();
        processorInfo.add("CPU, IOWait, and IRQ ticks @ 0 sec:&nbsp;&nbsp;" + Arrays.toString(prevTicks));
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        processorInfo.add("CPU, IOWait, and IRQ ticks @ 1 sec:&nbsp;&nbsp;" + Arrays.toString(ticks));
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        processorInfo.add(String.format("User: %.1f%% Nice: %.1f%% System: %.1f%% Idle: %.1f%% IOwait: %.1f%% IRQ: %.1f%% SoftIRQ: %.1f%% Steal: %.1f%%", 100.0 * (double)user / (double)totalCpu, 100.0 * (double)nice / (double)totalCpu, 100.0 * (double)sys / (double)totalCpu, 100.0 * (double)idle / (double)totalCpu, 100.0 * (double)iowait / (double)totalCpu, 100.0 * (double)irq / (double)totalCpu, 100.0 * (double)softirq / (double)totalCpu, 100.0 * (double)steal / (double)totalCpu));
        processorInfo.add(String.format("CPU load:&nbsp;&nbsp; %.1f%%", processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0));
        double[] loadAverage = processor.getSystemLoadAverage(3);
        processorInfo.add("CPU load averages:&nbsp;&nbsp;" + (loadAverage[0] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[0])) + (loadAverage[1] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[1])) + (loadAverage[2] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[2])));
        StringBuilder procCpu = new StringBuilder("CPU load per processor:&nbsp;&nbsp;");
        for (double avg : load = processor.getProcessorCpuLoadBetweenTicks(prevProcTicks)) {
            procCpu.append(String.format(" %.1f%%", avg * 100.0));
        }
        processorInfo.add(procCpu.toString());
        long freq = processor.getVendorFreq();
        if (freq > 0L) {
            processorInfo.add("Vendor Frequency:&nbsp;&nbsp; " + FormatUtil.formatHertz((long)freq));
        }
        if ((freq = processor.getMaxFreq()) > 0L) {
            processorInfo.add("Max Frequency:&nbsp;&nbsp; " + FormatUtil.formatHertz((long)freq));
        }
        if ((freqs = processor.getCurrentFreq())[0] > 0L) {
            StringBuilder sb = new StringBuilder("Current Frequencies:&nbsp;&nbsp; ");
            for (int i = 0; i < freqs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FormatUtil.formatHertz((long)freqs[i]));
            }
            processorInfo.add(sb.toString());
        }
        return processorInfo;
    }

    private List<String> getMemory(GlobalMemory memory) {
        ArrayList<String> memoryInfo = new ArrayList<String>();
        memoryInfo.add("Memory:&nbsp;&nbsp; " + FormatUtil.formatBytes((long)memory.getAvailable()) + "/" + FormatUtil.formatBytes((long)memory.getTotal()));
        VirtualMemory vm = memory.getVirtualMemory();
        memoryInfo.add("Swap used:&nbsp;&nbsp; " + FormatUtil.formatBytes((long)vm.getSwapUsed()) + "/" + FormatUtil.formatBytes((long)vm.getSwapTotal()));
        return memoryInfo;
    }

    private List<String> getProcesses(OperatingSystem os, GlobalMemory memory) {
        ArrayList<String> processInfo = new ArrayList<String>();
        processInfo.add("Processes:&nbsp;&nbsp; " + os.getProcessCount() + ", Threads:&nbsp;&nbsp; " + os.getThreadCount());
        List<OSProcess> procs = Arrays.asList(os.getProcesses(5, OperatingSystem.ProcessSort.CPU));
        processInfo.add("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PID  %CPU %MEM       VSZ       RSS Name");
        for (int i = 0; i < procs.size() && i < 5; ++i) {
            OSProcess p = procs.get(i);
            processInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; %5d %5.1f %4.1f %9s %9s %s", p.getProcessID(), 100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime(), 100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal(), FormatUtil.formatBytes((long)p.getVirtualSize()), FormatUtil.formatBytes((long)p.getResidentSetSize()), p.getName()));
        }
        return processInfo;
    }

    private List<String> getDisks(HWDiskStore[] diskStores) {
        ArrayList<String> diskInfo = new ArrayList<String>();
        diskInfo.add("Disks:&nbsp;&nbsp;");
        for (HWDiskStore disk : diskStores) {
            HWPartition[] partitions;
            boolean readwrite = disk.getReads() > 0L || disk.getWrites() > 0L;
            diskInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; %s: (model: %s - S/N: %s) size: %s, reads: %s (%s), writes: %s (%s), xfer: %s ms", disk.getName(), disk.getModel(), disk.getSerial(), disk.getSize() > 0L ? FormatUtil.formatBytesDecimal((long)disk.getSize()) : "?", readwrite ? Long.valueOf(disk.getReads()) : "?", readwrite ? FormatUtil.formatBytes((long)disk.getReadBytes()) : "?", readwrite ? Long.valueOf(disk.getWrites()) : "?", readwrite ? FormatUtil.formatBytes((long)disk.getWriteBytes()) : "?", readwrite ? Long.valueOf(disk.getTransferTime()) : "?"));
            for (HWPartition part : partitions = disk.getPartitions()) {
                diskInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |-- %s: %s (%s) Maj:Min=%d:%d, size: %s%s", part.getIdentification(), part.getName(), part.getType(), part.getMajor(), part.getMinor(), FormatUtil.formatBytesDecimal((long)part.getSize()), part.getMountPoint().isEmpty() ? "" : " @ " + part.getMountPoint()));
            }
        }
        return diskInfo;
    }

    private List<String> getFileSystem(FileSystem fileSystem) {
        OSFileStore[] fsArray;
        ArrayList<String> fsInfo = new ArrayList<String>();
        fsInfo.add("File System:&nbsp;&nbsp;");
        fsInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;File Descriptors: %d/%d", fileSystem.getOpenFileDescriptors(), fileSystem.getMaxFileDescriptors()));
        for (OSFileStore fs : fsArray = fileSystem.getFileStores()) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            fsInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;%s (%s) [%s] %s of %s free (%.1f%%), %s of %s files free (%.1f%%) is %s " + (fs.getLogicalVolume() != null && fs.getLogicalVolume().length() > 0 ? "[%s]" : "%s") + " and is mounted at %s", fs.getName(), fs.getDescription().isEmpty() ? "file system" : fs.getDescription(), fs.getType(), FormatUtil.formatBytes((long)usable), FormatUtil.formatBytes((long)fs.getTotalSpace()), 100.0 * (double)usable / (double)total, FormatUtil.formatValue((long)fs.getFreeInodes(), (String)""), FormatUtil.formatValue((long)fs.getTotalInodes(), (String)""), 100.0 * (double)fs.getFreeInodes() / (double)fs.getTotalInodes(), fs.getVolume(), fs.getLogicalVolume(), fs.getMount()));
        }
        return fsInfo;
    }

    private List<String> getNetworkInterfaces(NetworkIF[] networkIFs) {
        ArrayList<String> getNetwork = new ArrayList<String>();
        getNetwork.add("Network interfaces:&nbsp;&nbsp;");
        for (NetworkIF net : networkIFs) {
            getNetwork.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;Name: %s (%s)", net.getName(), net.getDisplayName()));
            getNetwork.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MAC Address: %s", net.getMacaddr()));
            getNetwork.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MTU: %s, Speed: %s", net.getMTU(), FormatUtil.formatValue((long)net.getSpeed(), (String)"bps")));
            getNetwork.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;IPv4: %s", Arrays.toString(net.getIPv4addr())));
            getNetwork.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;IPv6: %s", Arrays.toString(net.getIPv6addr())));
            boolean hasData = net.getBytesRecv() > 0L || net.getBytesSent() > 0L || net.getPacketsRecv() > 0L || net.getPacketsSent() > 0L;
            getNetwork.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Traffic: received %s/%s%s; transmitted %s/%s%s", hasData ? net.getPacketsRecv() + " packets" : "?", hasData ? FormatUtil.formatBytes((long)net.getBytesRecv()) : "?", hasData ? " (" + net.getInErrors() + " err)" : "", hasData ? net.getPacketsSent() + " packets" : "?", hasData ? FormatUtil.formatBytes((long)net.getBytesSent()) : "?", hasData ? " (" + net.getOutErrors() + " err)" : ""));
        }
        return getNetwork;
    }

    private List<String> getNetworkParameters(NetworkParams networkParams) {
        ArrayList<String> networkParameterInfo = new ArrayList<String>();
        networkParameterInfo.add("Network parameters:&nbsp;&nbsp;&nbsp;&nbsp;");
        networkParameterInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Host name: %s", networkParams.getHostName()));
        networkParameterInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Domain name: %s", networkParams.getDomainName()));
        networkParameterInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; DNS servers: %s", Arrays.toString(networkParams.getDnsServers())));
        networkParameterInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; IPv4 Gateway: %s", networkParams.getIpv4DefaultGateway()));
        networkParameterInfo.add(String.format("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; IPv6 Gateway: %s", networkParams.getIpv6DefaultGateway()));
        return networkParameterInfo;
    }
}

