/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.ha.HAProtocol;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.persist.Storage;
import org.apache.doris.system.Frontend;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1"})
public class HaController {
    @RequestMapping(path={"/ha"}, method={RequestMethod.GET})
    public Object ha() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.appendRoleInfo(result);
        this.appendJournalInfo(result);
        this.appendCanReadInfo(result);
        this.appendNodesInfo(result);
        this.appendImageInfo(result);
        this.appendDbNames(result);
        this.appendFe(result);
        this.appendRemovedFe(result);
        return ResponseEntityBuilder.ok(result);
    }

    private void appendRoleInfo(Map<String, Object> result) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        info.put("Name", "FrontendRole");
        info.put("Value", (Object)Catalog.getCurrentCatalog().getFeType());
        list.add(info);
        result.put("FrontendRole", list);
    }

    private void appendJournalInfo(Map<String, Object> result) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        if (Catalog.getCurrentCatalog().isMaster()) {
            info.put("Name", "FrontendRole");
            info.put("Value", Catalog.getCurrentCatalog().getEditLog().getMaxJournalId());
        } else {
            info.put("Name", "FrontendRole");
            info.put("Value", Catalog.getCurrentCatalog().getReplayedJournalId());
        }
        list.add(info);
        result.put("CurrentJournalId", list);
    }

    private void appendNodesInfo(Map<String, Object> result) {
        HAProtocol haProtocol = Catalog.getCurrentCatalog().getHaProtocol();
        if (haProtocol == null) {
            return;
        }
        List<InetSocketAddress> electableNodes = haProtocol.getElectableNodes(true);
        if (electableNodes.isEmpty()) {
            return;
        }
        ArrayList eleclist = new ArrayList();
        for (InetSocketAddress node : electableNodes) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("Name", node.getHostName());
            info.put("Value", node.getAddress());
            eleclist.add(info);
        }
        result.put("Electablenodes", eleclist);
        List<InetSocketAddress> observerNodes = haProtocol.getObserverNodes();
        if (observerNodes == null) {
            return;
        }
        ArrayList list = new ArrayList();
        for (InetSocketAddress node : observerNodes) {
            HashMap<String, String> observer = new HashMap<String, String>();
            observer.put("Name", node.getHostName());
            observer.put("Value", node.getHostString());
            list.add(observer);
        }
        result.put("Observernodes", list);
    }

    private void appendCanReadInfo(Map<String, Object> result) {
        HashMap<String, Object> canRead = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        canRead.put("Name", "Status");
        canRead.put("Value", Catalog.getCurrentCatalog().canRead());
        list.add(canRead);
        result.put("CanRead", list);
    }

    private void appendImageInfo(Map<String, Object> result) {
        try {
            ArrayList list = new ArrayList();
            HashMap<String, Object> checkPoint = new HashMap<String, Object>();
            Storage storage = new Storage(Config.meta_dir + "/image");
            checkPoint.put("Name", "Version");
            checkPoint.put("Value", storage.getLatestImageSeq());
            list.add(checkPoint);
            long lastCheckpointTime = storage.getCurrentImageFile().lastModified();
            Date date = new Date(lastCheckpointTime);
            HashMap<String, Object> checkPoint1 = new HashMap<String, Object>();
            checkPoint1.put("Name", "lastCheckPointTime");
            checkPoint1.put("Value", date);
            list.add(checkPoint1);
            result.put("CheckpointInfo", list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void appendDbNames(Map<String, Object> result) {
        HashMap<String, String> dbs = new HashMap<String, String>();
        List<Long> names = Catalog.getCurrentCatalog().getEditLog().getDatabaseNames();
        if (names == null) {
            return;
        }
        String msg = "";
        for (long name : names) {
            msg = msg + name + " ";
        }
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        dbs.put("Name", "DatabaseNames");
        dbs.put("Value", msg);
        list.add(dbs);
        result.put("databaseNames", list);
    }

    private void appendFe(Map<String, Object> result) {
        List<Frontend> fes = Catalog.getCurrentCatalog().getFrontends(null);
        if (fes == null) {
            return;
        }
        ArrayList list = new ArrayList();
        for (Frontend fe : fes) {
            HashMap<String, String> allowed = new HashMap<String, String>();
            allowed.put("Name", fe.getNodeName());
            allowed.put("Value", fe.toString());
            list.add(allowed);
        }
        result.put("allowedFrontends", list);
    }

    private void appendRemovedFe(Map<String, Object> result) {
        List<String> feNames = Catalog.getCurrentCatalog().getRemovedFrontendNames();
        ArrayList list = new ArrayList();
        for (String feName : feNames) {
            HashMap<String, String> removed = new HashMap<String, String>();
            removed.put("Name", feName);
            removed.put("Value", feName);
            list.add(removed);
        }
        result.put("removedFrontends", list);
    }
}

