/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.controller;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.Config;
import org.apache.doris.httpv2.HttpAuthManager;
import org.apache.doris.httpv2.exception.UnauthorizedException;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.service.FrontendOptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseController {
    private static final Logger LOG = LogManager.getLogger(BaseController.class);
    public static final String PALO_SESSION_ID = "PALO_SESSION_ID";
    private static final int PALO_SESSION_EXPIRED_TIME = 86400;

    public void checkAuthWithCookie(HttpServletRequest request, HttpServletResponse response) {
        this.checkWithCookie(request, response, true);
    }

    public ActionAuthorizationInfo checkWithCookie(HttpServletRequest request, HttpServletResponse response, boolean checkAuth) {
        String encodedAuthString = request.getHeader("Authorization");
        if (encodedAuthString != null) {
            ActionAuthorizationInfo authInfo = this.getAuthorizationInfo(request);
            UserIdentity currentUser = this.checkPassword(authInfo);
            if (checkAuth) {
                this.checkGlobalAuth(currentUser, PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.NODE_PRIV), CompoundPredicate.Operator.OR));
            }
            HttpAuthManager.SessionValue value = new HttpAuthManager.SessionValue();
            value.currentUser = currentUser;
            value.password = authInfo.password;
            this.addSession(request, response, value);
            ConnectContext ctx = new ConnectContext(null);
            ctx.setQualifiedUser(authInfo.fullUserName);
            ctx.setRemoteIP(authInfo.remoteIp);
            ctx.setCurrentUserIdentity(currentUser);
            ctx.setCatalog(Catalog.getCurrentCatalog());
            ctx.setCluster("default_cluster");
            ctx.setThreadLocalInfo();
            LOG.debug("check auth without cookie success for user: {}, thread: {}", (Object)currentUser, (Object)Thread.currentThread().getId());
            return authInfo;
        }
        ActionAuthorizationInfo authInfo = this.checkCookie(request, response, checkAuth);
        if (authInfo == null) {
            throw new UnauthorizedException("Cookie is invalid");
        }
        return authInfo;
    }

    protected void addSession(HttpServletRequest request, HttpServletResponse response, HttpAuthManager.SessionValue value) {
        String key = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(PALO_SESSION_ID, key);
        cookie.setMaxAge(86400);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
        LOG.debug("add session cookie: {} {}", (Object)PALO_SESSION_ID, (Object)key);
        HttpAuthManager.getInstance().addSessionValue(key, value);
    }

    private ActionAuthorizationInfo checkCookie(HttpServletRequest request, HttpServletResponse response, boolean checkAuth) {
        List<String> sessionIds = this.getCookieValues(request, PALO_SESSION_ID, response);
        if (sessionIds.isEmpty()) {
            return null;
        }
        HttpAuthManager authMgr = HttpAuthManager.getInstance();
        HttpAuthManager.SessionValue sessionValue = authMgr.getSessionValue(sessionIds);
        if (sessionValue == null) {
            return null;
        }
        if (checkAuth && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(sessionValue.currentUser, PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.NODE_PRIV), CompoundPredicate.Operator.OR))) {
            return null;
        }
        this.updateCookieAge(request, PALO_SESSION_ID, 86400, response);
        ConnectContext ctx = new ConnectContext(null);
        ctx.setQualifiedUser(sessionValue.currentUser.getQualifiedUser());
        ctx.setRemoteIP(request.getRemoteHost());
        ctx.setCurrentUserIdentity(sessionValue.currentUser);
        ctx.setCatalog(Catalog.getCurrentCatalog());
        ctx.setCluster("default_cluster");
        ctx.setThreadLocalInfo();
        LOG.debug("check cookie success for user: {}, thread: {}", (Object)sessionValue.currentUser, (Object)Thread.currentThread().getId());
        ActionAuthorizationInfo authInfo = new ActionAuthorizationInfo();
        authInfo.fullUserName = sessionValue.currentUser.getQualifiedUser();
        authInfo.remoteIp = request.getRemoteHost();
        authInfo.password = sessionValue.password;
        authInfo.cluster = "default_cluster";
        return authInfo;
    }

    public List<String> getCookieValues(HttpServletRequest request, String cookieName, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        ArrayList sessionIds = Lists.newArrayList();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName() == null || !cookie.getName().equals(cookieName)) continue;
                String sessionId = cookie.getValue();
                sessionIds.add(sessionId);
            }
        }
        return sessionIds;
    }

    public void updateCookieAge(HttpServletRequest request, String cookieName, int age, HttpServletResponse response) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (cookie.getName() == null || !cookie.getName().equals(cookieName)) continue;
            cookie.setMaxAge(age);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }

    protected void checkGlobalAuth(UserIdentity currentUser, PrivPredicate predicate) throws UnauthorizedException {
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(currentUser, predicate)) {
            throw new UnauthorizedException("Access denied; you need (at least one of) the " + predicate.getPrivs().toString() + " privilege(s) for this operation");
        }
    }

    protected void checkDbAuth(UserIdentity currentUser, String db, PrivPredicate predicate) throws UnauthorizedException {
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(currentUser, db, predicate)) {
            throw new UnauthorizedException("Access denied; you need (at least one of) the " + predicate.getPrivs().toString() + " privilege(s) for this operation");
        }
    }

    protected void checkTblAuth(UserIdentity currentUser, String db, String tbl, PrivPredicate predicate) throws UnauthorizedException {
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(currentUser, db, tbl, predicate)) {
            throw new UnauthorizedException("Access denied; you need (at least one of) the " + predicate.getPrivs().toString() + " privilege(s) for this operation");
        }
    }

    protected UserIdentity checkPassword(ActionAuthorizationInfo authInfo) throws UnauthorizedException {
        ArrayList currentUser = Lists.newArrayList();
        if (!Catalog.getCurrentCatalog().getAuth().checkPlainPassword(authInfo.fullUserName, authInfo.remoteIp, authInfo.password, currentUser)) {
            throw new UnauthorizedException("Access denied for " + authInfo.fullUserName + "@" + authInfo.remoteIp);
        }
        Preconditions.checkState((currentUser.size() == 1 ? 1 : 0) != 0);
        return (UserIdentity)currentUser.get(0);
    }

    public ActionAuthorizationInfo getAuthorizationInfo(HttpServletRequest request) throws UnauthorizedException {
        ActionAuthorizationInfo authInfo = new ActionAuthorizationInfo();
        if (!this.parseAuthInfo(request, authInfo)) {
            LOG.info("parse auth info failed, Authorization header {}, url {}", (Object)request.getHeader("Authorization"), (Object)request.getRequestURI());
            throw new UnauthorizedException("Need auth information.");
        }
        LOG.debug("get auth info: {}", (Object)authInfo);
        return authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAuthInfo(HttpServletRequest request, ActionAuthorizationInfo authInfo) {
        String encodedAuthString = request.getHeader("Authorization");
        if (Strings.isNullOrEmpty((String)encodedAuthString)) {
            return false;
        }
        String[] parts = encodedAuthString.split(" ");
        if (parts.length != 2) {
            return false;
        }
        encodedAuthString = parts[1];
        ByteBuf buf = null;
        ByteBuf decodeBuf = null;
        try {
            buf = Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.wrap(encodedAuthString.getBytes()));
            decodeBuf = Base64.decode((ByteBuf)buf);
            String authString = decodeBuf.toString(CharsetUtil.UTF_8);
            int index = authString.indexOf(":");
            authInfo.fullUserName = authString.substring(0, index);
            String[] elements = authInfo.fullUserName.split("@");
            if (elements != null && elements.length < 2) {
                authInfo.fullUserName = ClusterNamespace.getFullName("default_cluster", authInfo.fullUserName);
                authInfo.cluster = "default_cluster";
            } else if (elements != null && elements.length == 2) {
                authInfo.fullUserName = ClusterNamespace.getFullName(elements[1], elements[0]);
                authInfo.cluster = elements[1];
            }
            authInfo.password = authString.substring(index + 1);
            authInfo.remoteIp = request.getRemoteAddr();
        }
        finally {
            if (buf != null) {
                buf.release();
            }
            if (decodeBuf != null) {
                decodeBuf.release();
            }
        }
        return true;
    }

    protected int checkIntParam(String strParam) {
        return Integer.parseInt(strParam);
    }

    protected long checkLongParam(String strParam) {
        return Long.parseLong(strParam);
    }

    protected String getCurrentFrontendURL() {
        return "http://" + FrontendOptions.getLocalHostAddress() + ":" + Config.http_port;
    }

    public static class ActionAuthorizationInfo {
        public String fullUserName;
        public String remoteIp;
        public String password;
        public String cluster;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("user: ").append(this.fullUserName).append(", remote ip: ").append(this.remoteIp);
            sb.append(", password: ").append(this.password).append(", cluster: ").append(this.cluster);
            return sb.toString();
        }
    }
}

