/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.config;

import org.apache.doris.common.Config;
import org.apache.doris.httpv2.interceptor.AuthInterceptor;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfigurer
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuthInterceptor()).addPathPatterns(new String[]{"/rest/v1/**"}).excludePathPatterns(new String[]{"/", "/api/**", "/rest/v1/login", "/rest/v1/logout", "/static/**", "/metrics"}).excludePathPatterns(new String[]{"/image", "/info", "/version", "/put", "/journal_id", "/role", "/check", "/dump"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowCredentials(false).allowedMethods(new String[]{"*"}).allowedOrigins(new String[]{"*"}).allowedHeaders(new String[]{"*"}).maxAge(3600L);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/notFound").setStatusCode(HttpStatus.OK).setViewName("forward:/index.html");
    }

    @Bean
    public WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> containerCustomizer() {
        return container -> container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.NOT_FOUND, "/notFound")});
    }

    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver multipartResolver() {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        multipartResolver.setMaxUploadSize((long)Config.jetty_server_max_http_post_size);
        return multipartResolver;
    }
}

