/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.config;

import java.io.File;
import org.apache.doris.common.Log4jConfig;
import org.springframework.beans.BeansException;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class ReadEnvironment
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void reinitializeLoggingSystem() {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)this.applicationContext.getEnvironment();
        File file = new File(Log4jConfig.confDir + "log4j2-spring.xml");
        String logConfig = file.getAbsolutePath();
        LogFile logFile = LogFile.get((PropertyResolver)environment);
        LoggingSystem system = LoggingSystem.get((ClassLoader)LoggingSystem.class.getClassLoader());
        try {
            ResourceUtils.getURL((String)logConfig).openStream().close();
            system.cleanUp();
            system.beforeInitialize();
            system.initialize(new LoggingInitializationContext(environment), logConfig, logFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

