/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2;

import java.util.HashMap;
import org.apache.doris.PaloFe;
import org.apache.doris.common.Config;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;

@SpringBootApplication
@EnableConfigurationProperties
@ServletComponentScan
public class HttpServer
extends SpringBootServletInitializer {
    private int port;
    private int acceptors;
    private int selectors;
    private int maxHttpPostSize;
    private int workers;

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    public void setMaxHttpPostSize(int maxHttpPostSize) {
        this.maxHttpPostSize = maxHttpPostSize;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{HttpServer.class});
    }

    public void start(String dorisHome) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("server.port", this.port);
        properties.put("server.servlet.context-path", "/");
        properties.put("spring.resources.static-locations", "classpath:/static");
        properties.put("spring.http.encoding.charset", "UTF-8");
        properties.put("spring.http.encoding.enabled", true);
        properties.put("spring.http.encoding.force", true);
        properties.put("server.jetty.acceptors", this.acceptors);
        properties.put("server.jetty.max-http-post-size", this.maxHttpPostSize);
        properties.put("server.jetty.selectors", this.selectors);
        if (this.workers > 0) {
            properties.put("server.jetty.workers", this.workers);
        }
        System.setProperty("spring.devtools.restart.enabled", "false");
        if (PaloFe.DORIS_HOME_DIR != null) {
            System.setProperty("spring.http.multipart.location", PaloFe.DORIS_HOME_DIR);
        }
        System.setProperty("spring.banner.image.location", "doris-logo.png");
        properties.put("logging.config", Config.custom_config_dir + "/" + "log4j2-spring.xml");
        new SpringApplicationBuilder(new Class[0]).sources(new Class[]{HttpServer.class}).properties(properties).run(new String[0]);
    }
}

