/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.doris.analysis.UserIdentity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HttpAuthManager {
    private static final Logger LOG = LogManager.getLogger(HttpAuthManager.class);
    private static long SESSION_EXPIRE_TIME = 2L;
    private static long SESSION_MAX_SIZE = 100L;
    private static HttpAuthManager instance = new HttpAuthManager();
    private Cache<String, SessionValue> authSessions = CacheBuilder.newBuilder().maximumSize(SESSION_MAX_SIZE).expireAfterAccess(SESSION_EXPIRE_TIME, TimeUnit.HOURS).build();

    private HttpAuthManager() {
    }

    public static HttpAuthManager getInstance() {
        return instance;
    }

    public SessionValue getSessionValue(List<String> sessionIds) {
        for (String sessionId : sessionIds) {
            SessionValue sv = (SessionValue)this.authSessions.getIfPresent((Object)sessionId);
            if (sv == null) continue;
            LOG.debug("get session value {} by session id: {}, left size: {}", (Object)(sv == null ? null : sv.currentUser), (Object)sessionId, (Object)this.authSessions.size());
            return sv;
        }
        return null;
    }

    public void removeSession(String sessionId) {
        if (!Strings.isNullOrEmpty((String)sessionId)) {
            this.authSessions.invalidate((Object)sessionId);
            LOG.debug("remove session id: {}, left size: {}", (Object)sessionId, (Object)this.authSessions.size());
        }
    }

    public void addSessionValue(String key, SessionValue value) {
        this.authSessions.put((Object)key, (Object)value);
    }

    public Cache<String, SessionValue> getAuthSessions() {
        return this.authSessions;
    }

    public static class SessionValue {
        public UserIdentity currentUser;
        public String password;
    }
}

