/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.ha;

import com.google.common.base.Preconditions;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.util.Util;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BDBStateChangeListener
implements StateChangeListener {
    public static final Logger LOG = LogManager.getLogger(BDBStateChangeListener.class);

    public synchronized void stateChange(StateChangeEvent sce) throws RuntimeException {
        FrontendNodeType newType = null;
        switch (sce.getState()) {
            case MASTER: {
                newType = FrontendNodeType.MASTER;
                break;
            }
            case REPLICA: {
                if (Catalog.getCurrentCatalog().isElectable()) {
                    newType = FrontendNodeType.FOLLOWER;
                    break;
                }
                newType = FrontendNodeType.OBSERVER;
                break;
            }
            case UNKNOWN: {
                newType = FrontendNodeType.UNKNOWN;
                break;
            }
            default: {
                String msg = "this node is " + sce.getState().name();
                LOG.warn(msg);
                Util.stdoutWithTime(msg);
                return;
            }
        }
        Preconditions.checkNotNull((Object)((Object)newType));
        Catalog.getCurrentCatalog().notifyNewFETypeTransfer(newType);
    }
}

