/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.ha;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.ha.HAProtocol;
import org.apache.doris.journal.bdbje.BDBEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BDBHA
implements HAProtocol {
    private static final Logger LOG = LogManager.getLogger(BDBHA.class);
    private BDBEnvironment environment;
    private String nodeName;
    private static final int RETRY_TIME = 3;

    public BDBHA(BDBEnvironment env, String nodeName) {
        this.environment = env;
        this.nodeName = nodeName;
    }

    @Override
    public long getEpochNumber() {
        return 0L;
    }

    @Override
    public boolean fencing() {
        Database epochDb = this.environment.getEpochDB();
        for (int i = 0; i < 3; ++i) {
            try {
                long count = epochDb.count();
                long myEpoch = count + 1L;
                LOG.info("start fencing, epoch number is {}", (Object)myEpoch);
                Long key = myEpoch;
                DatabaseEntry theKey = new DatabaseEntry();
                TupleBinding idBinding = TupleBinding.getPrimitiveBinding(Long.class);
                idBinding.objectToEntry((Object)key, theKey);
                DatabaseEntry theData = new DatabaseEntry(new byte[1]);
                OperationStatus status = epochDb.putNoOverwrite(null, theKey, theData);
                if (status == OperationStatus.SUCCESS) {
                    Catalog.getCurrentCatalog().setEpoch(myEpoch);
                    return true;
                }
                if (status == OperationStatus.KEYEXIST) {
                    return false;
                }
                throw new Exception(status.toString());
            }
            catch (Exception e) {
                LOG.error("fencing failed. tried {} times", (Object)i, (Object)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
        }
        return false;
    }

    @Override
    public List<InetSocketAddress> getObserverNodes() {
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        if (replicationGroupAdmin == null) {
            return null;
        }
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        try {
            ReplicationGroup replicationGroup = replicationGroupAdmin.getGroup();
            for (ReplicationNode replicationNode : replicationGroup.getSecondaryNodes()) {
                ret.add(replicationNode.getSocketAddress());
            }
        }
        catch (UnknownMasterException e) {
            LOG.warn("Catch UnknownMasterException when calling getObserverNodes.", (Throwable)e);
            return Lists.newArrayList();
        }
        return ret;
    }

    @Override
    public List<InetSocketAddress> getElectableNodes(boolean leaderIncluded) {
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        if (replicationGroupAdmin == null) {
            return null;
        }
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        try {
            ReplicationGroup replicationGroup = replicationGroupAdmin.getGroup();
            for (ReplicationNode replicationNode : replicationGroup.getElectableNodes()) {
                if (leaderIncluded) {
                    ret.add(replicationNode.getSocketAddress());
                    continue;
                }
                if (replicationNode.getName().equals(replicationGroupAdmin.getMasterNodeName())) continue;
                ret.add(replicationNode.getSocketAddress());
            }
        }
        catch (UnknownMasterException e) {
            LOG.warn("Catch UnknownMasterException when calling getElectableNodes.", (Throwable)e);
            return Lists.newArrayList();
        }
        return ret;
    }

    @Override
    public InetSocketAddress getLeader() {
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        String leaderName = replicationGroupAdmin.getMasterNodeName();
        ReplicationGroup rg = replicationGroupAdmin.getGroup();
        ReplicationNode rn = rg.getMember(leaderName);
        return rn.getSocketAddress();
    }

    @Override
    public List<InetSocketAddress> getNoneLeaderNodes() {
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        if (replicationGroupAdmin == null) {
            return null;
        }
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        try {
            ReplicationGroup replicationGroup = replicationGroupAdmin.getGroup();
            for (ReplicationNode replicationNode : replicationGroup.getSecondaryNodes()) {
                ret.add(replicationNode.getSocketAddress());
            }
            for (ReplicationNode replicationNode : replicationGroup.getElectableNodes()) {
                if (replicationNode.getName().equals(replicationGroupAdmin.getMasterNodeName())) continue;
                ret.add(replicationNode.getSocketAddress());
            }
        }
        catch (UnknownMasterException e) {
            LOG.warn("Catch UnknownMasterException when calling getNoneLeaderNodes.", (Throwable)e);
            return null;
        }
        return ret;
    }

    @Override
    public void transferToMaster() {
    }

    @Override
    public void transferToNonMaster() {
    }

    @Override
    public boolean isLeader() {
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        String leaderName = replicationGroupAdmin.getMasterNodeName();
        return leaderName.equals(this.nodeName);
    }

    @Override
    public boolean removeElectableNode(String nodeName) {
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        if (replicationGroupAdmin == null) {
            return false;
        }
        try {
            replicationGroupAdmin.removeMember(nodeName);
        }
        catch (MemberNotFoundException e) {
            LOG.error("the deleting electable node is not found {}", (Object)nodeName, (Object)e);
            return false;
        }
        catch (MasterStateException e) {
            LOG.error("the deleting electable node is master {}", (Object)nodeName, (Object)e);
            return false;
        }
        return true;
    }

    public void addHelperSocket(String ip, Integer port) {
        InetSocketAddress newHelperSocket;
        ReplicationGroupAdmin replicationGroupAdmin = this.environment.getReplicationGroupAdmin();
        HashSet helperSockets = Sets.newHashSet((Iterable)replicationGroupAdmin.getHelperSockets());
        if (!helperSockets.contains(newHelperSocket = new InetSocketAddress(ip, (int)port))) {
            helperSockets.add(newHelperSocket);
            this.environment.setNewReplicationGroupAdmin(helperSockets);
            LOG.info("add {}:{} to helper sockets", (Object)ip, (Object)port);
        }
    }
}

