/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg.util;

import java.util.List;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class TypeToDorisType
extends TypeUtil.SchemaVisitor<Type> {
    public Type schema(Schema schema, Type structType) {
        return structType;
    }

    public Type struct(Types.StructType struct, List<Type> fieldResults) {
        throw new UnsupportedOperationException(String.format("Cannot convert Iceberg type[%s] to Doris type.", struct));
    }

    public Type field(Types.NestedField field, Type fieldResult) {
        return fieldResult;
    }

    public Type list(Types.ListType list, Type elementResult) {
        throw new UnsupportedOperationException(String.format("Cannot convert Iceberg type[%s] to Doris type.", list));
    }

    public Type map(Types.MapType map, Type keyResult, Type valueResult) {
        throw new UnsupportedOperationException(String.format("Cannot convert Iceberg type[%s] to Doris type.", map));
    }

    public Type primitive(Type.PrimitiveType primitive) {
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case INTEGER: {
                return Type.INT;
            }
            case LONG: {
                return Type.BIGINT;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                return ScalarType.createDecimalV2Type(decimal.precision(), decimal.scale());
            }
            case DATE: {
                return Type.DATE;
            }
            case TIMESTAMP: {
                return Type.DATETIME;
            }
            case STRING: {
                return Type.STRING;
            }
            case UUID: {
                return Type.VARCHAR;
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert Iceberg type[%s] to Doris type.", primitive));
    }
}

