/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.external.iceberg.util.DorisTypeToType;
import org.apache.doris.external.iceberg.util.DorisTypeVisitor;
import org.apache.doris.external.iceberg.util.TypeToDorisType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.transforms.PartitionSpecVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IcebergUtils {
    private static final Logger LOG = LogManager.getLogger(IcebergUtils.class);
    private static ThreadLocal<Integer> columnIdThreadLocal = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return 0;
        }
    };

    public static Schema createIcebergSchema(List<ColumnDef> columnDefs) throws UserException {
        columnIdThreadLocal.set(1);
        ArrayList nestedFields = Lists.newArrayList();
        for (ColumnDef columnDef : columnDefs) {
            columnDef.analyze(false);
            if (columnDef.getAggregateType() != null) {
                throw new DdlException("Do not support aggregation column: " + columnDef.getName());
            }
            boolean isNullable = columnDef.isAllowNull();
            Type icebergType = IcebergUtils.convertDorisToIceberg(columnDef.getType());
            if (isNullable) {
                nestedFields.add(Types.NestedField.optional((int)IcebergUtils.nextId(), (String)columnDef.getName(), (Type)icebergType, (String)columnDef.getComment()));
                continue;
            }
            nestedFields.add(Types.NestedField.required((int)IcebergUtils.nextId(), (String)columnDef.getName(), (Type)icebergType, (String)columnDef.getComment()));
        }
        return new Schema((List)nestedFields);
    }

    public static List<Column> createSchemaFromIcebergSchema(Schema schema) throws DdlException {
        ArrayList columns = Lists.newArrayList();
        for (Types.NestedField nestedField : schema.columns()) {
            try {
                columns.add(IcebergUtils.nestedFieldToColumn(nestedField));
            }
            catch (UnsupportedOperationException e) {
                if (Config.iceberg_table_creation_strict_mode) {
                    throw e;
                }
                LOG.warn("Unsupported data type in Doris, ignore column[{}], with error: {}", (Object)nestedField.name(), (Object)e.getMessage());
            }
        }
        return columns;
    }

    public static Column nestedFieldToColumn(Types.NestedField field) {
        org.apache.doris.catalog.Type type = IcebergUtils.convertIcebergToDoris(field.type());
        return new Column(field.name(), type, true, null, field.isOptional(), null, field.doc());
    }

    public static Map<Integer, String> getIdToName(Schema schema) {
        HashMap<Integer, String> idToName = new HashMap<Integer, String>();
        for (Types.NestedField nestedField : schema.columns()) {
            idToName.put(nestedField.fieldId(), nestedField.name());
        }
        return idToName;
    }

    public static List<String> getIdentityPartitionField(PartitionSpec spec) {
        return PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)new PartitionSpecVisitor<String>(){

            public String identity(String sourceName, int sourceId) {
                return sourceName;
            }

            public String bucket(String sourceName, int sourceId, int numBuckets) {
                return null;
            }

            public String truncate(String sourceName, int sourceId, int width) {
                return null;
            }

            public String year(String sourceName, int sourceId) {
                return null;
            }

            public String month(String sourceName, int sourceId) {
                return null;
            }

            public String day(String sourceName, int sourceId) {
                return null;
            }

            public String hour(String sourceName, int sourceId) {
                return null;
            }

            public String alwaysNull(int fieldId, String sourceName, int sourceId) {
                return null;
            }

            public String unknown(int fieldId, String sourceName, int sourceId, String transform) {
                return null;
            }
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static org.apache.doris.catalog.Type convertIcebergToDoris(Type type) {
        return (org.apache.doris.catalog.Type)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToDorisType());
    }

    public static Type convertDorisToIceberg(org.apache.doris.catalog.Type type) {
        return DorisTypeVisitor.visit(type, new DorisTypeToType());
    }

    public static Expression convertToIcebergExpr(Expr expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BoolLiteral) {
            BoolLiteral boolLiteral = (BoolLiteral)expr;
            boolean value = boolLiteral.getValue();
            if (value) {
                return Expressions.alwaysTrue();
            }
            return Expressions.alwaysFalse();
        }
        if (expr instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)expr;
            switch (compoundPredicate.getOp()) {
                case AND: {
                    Expression left = IcebergUtils.convertToIcebergExpr((Expr)compoundPredicate.getChild(0));
                    Expression right = IcebergUtils.convertToIcebergExpr((Expr)compoundPredicate.getChild(1));
                    if (left != null && right != null) {
                        return Expressions.and((Expression)left, (Expression)right);
                    }
                    return null;
                }
                case OR: {
                    Expression left = IcebergUtils.convertToIcebergExpr((Expr)compoundPredicate.getChild(0));
                    Expression right = IcebergUtils.convertToIcebergExpr((Expr)compoundPredicate.getChild(1));
                    if (left != null && right != null) {
                        return Expressions.or((Expression)left, (Expression)right);
                    }
                    return null;
                }
                case NOT: {
                    Expression child = IcebergUtils.convertToIcebergExpr((Expr)compoundPredicate.getChild(0));
                    if (child != null) {
                        return Expressions.not((Expression)child);
                    }
                    return null;
                }
            }
            return null;
        }
        TExprOpcode opCode = expr.getOpcode();
        switch (opCode) {
            case EQ: 
            case EQ_FOR_NULL: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                BinaryPredicate eq = (BinaryPredicate)expr;
                SlotRef slotRef = IcebergUtils.convertDorisExprToSlotRef((Expr)eq.getChild(0));
                LiteralExpr literalExpr = null;
                if (slotRef == null && ((Expr)eq.getChild(0)).isLiteral()) {
                    literalExpr = (LiteralExpr)eq.getChild(0);
                    slotRef = IcebergUtils.convertDorisExprToSlotRef((Expr)eq.getChild(1));
                } else if (((Expr)eq.getChild(1)).isLiteral()) {
                    literalExpr = (LiteralExpr)eq.getChild(1);
                }
                if (slotRef == null || literalExpr == null) {
                    return null;
                }
                String colName = slotRef.getColumnName();
                Object value = IcebergUtils.extractDorisLiteral(literalExpr);
                if (value == null) {
                    if (opCode == TExprOpcode.EQ_FOR_NULL && literalExpr instanceof NullLiteral) {
                        return Expressions.isNull((String)colName);
                    }
                    return null;
                }
                switch (opCode) {
                    case EQ: 
                    case EQ_FOR_NULL: {
                        return Expressions.equal((String)colName, (Object)value);
                    }
                    case NE: {
                        return Expressions.not((Expression)Expressions.equal((String)colName, (Object)value));
                    }
                    case GE: {
                        return Expressions.greaterThanOrEqual((String)colName, (Object)value);
                    }
                    case GT: {
                        return Expressions.greaterThan((String)colName, (Object)value);
                    }
                    case LE: {
                        return Expressions.lessThanOrEqual((String)colName, (Object)value);
                    }
                    case LT: {
                        return Expressions.lessThan((String)colName, (Object)value);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static Object extractDorisLiteral(Expr expr) {
        if (!expr.isLiteral()) {
            return null;
        }
        if (expr instanceof BoolLiteral) {
            BoolLiteral boolLiteral = (BoolLiteral)expr;
            return boolLiteral.getValue();
        }
        if (expr instanceof DateLiteral) {
            Date date;
            DateLiteral dateLiteral = (DateLiteral)expr;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            StringBuilder sb = new StringBuilder();
            sb.append(dateLiteral.getYear()).append(dateLiteral.getMonth()).append(dateLiteral.getDay()).append(dateLiteral.getHour()).append(dateLiteral.getMinute()).append(dateLiteral.getSecond());
            try {
                date = formatter.parse(sb.toString());
            }
            catch (ParseException e) {
                return null;
            }
            return date.getTime();
        }
        if (expr instanceof DecimalLiteral) {
            DecimalLiteral decimalLiteral = (DecimalLiteral)expr;
            return decimalLiteral.getValue();
        }
        if (expr instanceof FloatLiteral) {
            FloatLiteral floatLiteral = (FloatLiteral)expr;
            return floatLiteral.getValue();
        }
        if (expr instanceof IntLiteral) {
            IntLiteral intLiteral = (IntLiteral)expr;
            return intLiteral.getValue();
        }
        if (expr instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expr;
            return stringLiteral.getStringValue();
        }
        return null;
    }

    private static SlotRef convertDorisExprToSlotRef(Expr expr) {
        SlotRef slotRef = null;
        if (expr instanceof SlotRef) {
            slotRef = (SlotRef)expr;
        } else if (expr instanceof CastExpr && expr.getChild(0) instanceof SlotRef) {
            slotRef = (SlotRef)expr.getChild(0);
        }
        return slotRef;
    }

    private static int findWidth(IntLiteral literal) {
        Preconditions.checkArgument((literal.getValue() > 0L && literal.getValue() < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)("Unsupported width " + literal.getValue()));
        return (int)literal.getValue();
    }

    public static int nextId() {
        int nextId = columnIdThreadLocal.get();
        columnIdThreadLocal.set(nextId + 1);
        return nextId;
    }

    public static Set<String> getAllDataFilesPath(Table table, TableOperations ops) {
        Table dataFilesTable = MetadataTableUtils.createMetadataTableInstance((TableOperations)ops, (String)table.name(), (String)table.name(), (MetadataTableType)MetadataTableType.ALL_DATA_FILES);
        HashSet dataFilesPath = Sets.newHashSet();
        TableScan tableScan = dataFilesTable.newScan();
        ArrayList tasks = Lists.newArrayList((Iterable)tableScan.planTasks());
        tasks.forEach(task -> task.files().forEach(fileScanTask -> Lists.newArrayList((Iterable)fileScanTask.asDataTask().rows()).forEach(row -> dataFilesPath.add((String)row.get(1, String.class)))));
        return dataFilesPath;
    }

    public static PartitionSpec buildPartitionSpec(Schema schema, List<String> partitionNames) {
        if (partitionNames == null || partitionNames.isEmpty()) {
            return null;
        }
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        for (String partitionName : partitionNames) {
            builder.identity(partitionName);
        }
        return builder.build();
    }
}

