/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.MapType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.StructType;
import org.apache.doris.catalog.Type;

public class DorisTypeVisitor<T> {
    public static <T> T visit(Type type, DorisTypeVisitor<T> visitor) {
        if (type instanceof StructType) {
            ArrayList<StructField> fields = ((StructType)type).getFields();
            ArrayList fieldResults = Lists.newArrayListWithExpectedSize((int)fields.size());
            for (StructField field : fields) {
                fieldResults.add(visitor.field(field, DorisTypeVisitor.visit(field.getType(), visitor)));
            }
            return visitor.struct((StructType)type, fieldResults);
        }
        if (type instanceof MapType) {
            return visitor.map((MapType)type, DorisTypeVisitor.visit(((MapType)type).getKeyType(), visitor), DorisTypeVisitor.visit(((MapType)type).getValueType(), visitor));
        }
        if (type instanceof ArrayType) {
            return visitor.array((ArrayType)type, DorisTypeVisitor.visit(((ArrayType)type).getItemType(), visitor));
        }
        return visitor.atomic(type);
    }

    public T struct(StructType struct, List<T> fieldResults) {
        return null;
    }

    public T field(StructField field, T typeResult) {
        return null;
    }

    public T array(ArrayType array, T elementResult) {
        return null;
    }

    public T map(MapType map, T keyResult, T valueResult) {
        return null;
    }

    public T atomic(Type atomic) {
        return null;
    }
}

