/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg.util;

import java.util.List;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.MapType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.StructType;
import org.apache.doris.external.iceberg.util.DorisTypeVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DorisTypeToType
extends DorisTypeVisitor<Type> {
    private final StructType root;
    private int nextId = 0;

    public DorisTypeToType() {
        this.root = null;
    }

    public DorisTypeToType(StructType root) {
        this.root = root;
        this.nextId = root.getFields().size();
    }

    private int getNextId() {
        int next = this.nextId++;
        return next;
    }

    @Override
    public Type struct(StructType struct, List<Type> types) {
        throw new UnsupportedOperationException("Not a supported type: " + struct.toSql(0));
    }

    @Override
    public Type field(StructField field, Type typeResult) {
        return typeResult;
    }

    @Override
    public Type array(ArrayType array, Type elementType) {
        throw new UnsupportedOperationException("Not a supported type: " + array.toSql(0));
    }

    @Override
    public Type map(MapType map, Type keyType, Type valueType) {
        throw new UnsupportedOperationException("Not a supported type: " + map.toSql(0));
    }

    @Override
    public Type atomic(org.apache.doris.catalog.Type atomic) {
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.BOOLEAN)) {
            return Types.BooleanType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.TINYINT) || atomic.getPrimitiveType().equals((Object)PrimitiveType.SMALLINT) || atomic.getPrimitiveType().equals((Object)PrimitiveType.INT)) {
            return Types.IntegerType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.BIGINT) || atomic.getPrimitiveType().equals((Object)PrimitiveType.LARGEINT)) {
            return Types.LongType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.FLOAT)) {
            return Types.FloatType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.DOUBLE)) {
            return Types.DoubleType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.CHAR) || atomic.getPrimitiveType().equals((Object)PrimitiveType.VARCHAR)) {
            return Types.StringType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.DATE)) {
            return Types.DateType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.TIME)) {
            return Types.TimeType.get();
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.DECIMALV2) || atomic.getPrimitiveType().equals((Object)PrimitiveType.DECIMALV2)) {
            return Types.DecimalType.of((int)((ScalarType)atomic).getScalarPrecision(), (int)((ScalarType)atomic).getScalarScale());
        }
        if (atomic.getPrimitiveType().equals((Object)PrimitiveType.DATETIME)) {
            return Types.TimestampType.withZone();
        }
        throw new UnsupportedOperationException("Not a supported type: " + (Object)((Object)atomic.getPrimitiveType()));
    }
}

