/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.IcebergProperty;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.SystemIdGenerator;
import org.apache.doris.common.property.PropertySchema;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.external.iceberg.DorisIcebergException;
import org.apache.doris.external.iceberg.IcebergCatalog;
import org.apache.doris.external.iceberg.IcebergCatalogMgr;
import org.apache.doris.external.iceberg.IcebergTableCreationRecord;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IcebergTableCreationRecordMgr
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(IcebergTableCreationRecordMgr.class);
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private Map<Long, Database> icebergDbs = new ConcurrentHashMap<Long, Database>();
    private Map<Database, Map<TableIdentifier, IcebergProperty>> dbToTableIdentifiers = Maps.newConcurrentMap();
    private Map<Long, Map<Long, IcebergTableCreationRecord>> dbToTableToCreationRecord = Maps.newConcurrentMap();
    private Queue<IcebergTableCreationRecord> tableCreationRecordQueue = new PriorityQueue<IcebergTableCreationRecord>(new TableCreationComparator());
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public IcebergTableCreationRecordMgr() {
        super("iceberg_table_creation_record_mgr", Config.iceberg_table_creation_interval_second * 1000L);
    }

    public void registerDb(Database db) throws DdlException {
        long dbId = db.getId();
        this.icebergDbs.put(dbId, db);
        LOG.info("Register a new Iceberg database[{}-{}]", (Object)dbId, (Object)db.getFullName());
    }

    private void registerTable(Database db, TableIdentifier identifier, IcebergProperty icebergProperty) {
        if (this.dbToTableIdentifiers.containsKey(db)) {
            this.dbToTableIdentifiers.get(db).put(identifier, icebergProperty);
        } else {
            ConcurrentMap identifierToProperties = Maps.newConcurrentMap();
            identifierToProperties.put(identifier, icebergProperty);
            this.dbToTableIdentifiers.put(db, identifierToProperties);
        }
        LOG.info("Register a new table[{}] to database[{}]", (Object)identifier.name(), (Object)db.getFullName());
    }

    public void deregisterDb(Database db) {
        this.icebergDbs.remove(db.getId());
        this.dbToTableIdentifiers.remove(db);
        this.dbToTableToCreationRecord.remove(db.getId());
        LOG.info("Deregister database[{}-{}]", (Object)db.getFullName(), (Object)db.getId());
    }

    public void deregisterTable(Database db, IcebergTable table) {
        if (this.dbToTableIdentifiers.containsKey(db)) {
            TableIdentifier identifier = TableIdentifier.of((String[])new String[]{table.getIcebergDb(), table.getIcebergTbl()});
            Map<TableIdentifier, IcebergProperty> identifierToProperties = this.dbToTableIdentifiers.get(db);
            identifierToProperties.remove(identifier);
        }
        if (this.dbToTableToCreationRecord.containsKey(db.getId())) {
            Map<Long, IcebergTableCreationRecord> recordMap = this.dbToTableToCreationRecord.get(db.getId());
            recordMap.remove(table.getId());
        }
        LOG.info("Deregister table[{}-{}] from database[{}-{}]", (Object)table.getName(), (Object)table.getId(), (Object)db.getFullName(), (Object)db.getId());
    }

    private void removeDuplicateTables() {
        for (Map.Entry<Long, Map<Long, IcebergTableCreationRecord>> entry : this.dbToTableToCreationRecord.entrySet()) {
            Catalog.getCurrentCatalog().getDb(entry.getKey()).ifPresent(db -> {
                if (this.dbToTableIdentifiers.containsKey(db)) {
                    for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                        String tableName = ((IcebergTableCreationRecord)innerEntry.getValue()).getTable();
                        String icebergDbName = db.getDbProperties().getIcebergProperty().getDatabase();
                        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{icebergDbName, tableName});
                        this.dbToTableIdentifiers.get(db).remove(identifier);
                    }
                }
            });
        }
    }

    @Override
    protected void runAfterCatalogReady() {
        Database db;
        PropertySchema.DateProperty prop = new PropertySchema.DateProperty("key", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        Iterator<Map.Entry<Long, Database>> it = this.icebergDbs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Database> entry = it.next();
            db = entry.getValue();
            IcebergProperty icebergProperty = db.getDbProperties().getIcebergProperty();
            IcebergCatalog icebergCatalog = null;
            try {
                icebergCatalog = IcebergCatalogMgr.getCatalog(icebergProperty);
            }
            catch (DdlException e) {
                this.addTableCreationRecord(db.getId(), -1L, db.getFullName(), "", FAIL, prop.writeTimeFormat(new Date(System.currentTimeMillis())), e.getMessage());
                LOG.warn("Failed get Iceberg catalog, hive.metastore.uris[{}], error: {}", (Object)icebergProperty.getHiveMetastoreUris(), (Object)e.getMessage());
            }
            List<TableIdentifier> icebergTables = null;
            try {
                icebergTables = icebergCatalog.listTables(icebergProperty.getDatabase());
            }
            catch (DorisIcebergException e) {
                this.addTableCreationRecord(db.getId(), -1L, db.getFullName(), "", FAIL, prop.writeTimeFormat(new Date(System.currentTimeMillis())), e.getMessage());
                LOG.warn("Failed list remote Iceberg database, hive.metastore.uris[{}], database[{}], error: {}", (Object)icebergProperty.getHiveMetastoreUris(), (Object)icebergProperty.getDatabase(), (Object)e.getMessage());
            }
            for (TableIdentifier identifier : icebergTables) {
                IcebergProperty tableProperties = new IcebergProperty(icebergProperty);
                tableProperties.setTable(identifier.name());
                this.registerTable(db, identifier, tableProperties);
            }
            it.remove();
        }
        for (Map.Entry<Database, Map<TableIdentifier, IcebergProperty>> entry : this.dbToTableIdentifiers.entrySet()) {
            db = entry.getKey();
            for (Map.Entry<TableIdentifier, IcebergProperty> innerEntry : entry.getValue().entrySet()) {
                TableIdentifier identifier = innerEntry.getKey();
                IcebergProperty icebergProperty = innerEntry.getValue();
                long tableId = SystemIdGenerator.getNextId();
                try {
                    IcebergTable table = IcebergCatalogMgr.getTableFromIceberg(tableId, identifier.name(), icebergProperty, identifier, false);
                    if (!((Boolean)db.createTableWithLock((Table)table, (boolean)false, (boolean)false).first).booleanValue()) {
                        ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, table.getName());
                    }
                    this.addTableCreationRecord(db.getId(), tableId, db.getFullName(), table.getName(), SUCCESS, prop.writeTimeFormat(new Date(System.currentTimeMillis())), "");
                    LOG.info("Successfully create table[{}-{}]", (Object)table.getName(), (Object)tableId);
                }
                catch (Exception e) {
                    this.addTableCreationRecord(db.getId(), tableId, db.getFullName(), identifier.name(), FAIL, prop.writeTimeFormat(new Date(System.currentTimeMillis())), e.getMessage());
                    LOG.warn("Failed create table[{}], error: {}", (Object)identifier.name(), (Object)e.getMessage());
                }
            }
        }
        this.removeDuplicateTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTableCreationRecord(long dbId, long tableId, String db, String table, String status, String createTime, String errorMsg) {
        this.writeLock();
        try {
            Map<Long, IcebergTableCreationRecord> tableToRecord;
            IcebergTableCreationRecord record;
            block3: while (this.isQueueFull()) {
                record = this.tableCreationRecordQueue.poll();
                if (record == null) continue;
                Map<Long, IcebergTableCreationRecord> tableRecords = this.dbToTableToCreationRecord.get(record.getDbId());
                Iterator<Map.Entry<Long, IcebergTableCreationRecord>> tableRecordsIterator = tableRecords.entrySet().iterator();
                while (tableRecordsIterator.hasNext()) {
                    long t = tableRecordsIterator.next().getKey();
                    if (t != record.getTableId()) continue;
                    tableRecordsIterator.remove();
                    continue block3;
                }
            }
            record = new IcebergTableCreationRecord(dbId, tableId, db, table, status, createTime, errorMsg);
            this.tableCreationRecordQueue.offer(record);
            if (!this.dbToTableToCreationRecord.containsKey(dbId)) {
                this.dbToTableToCreationRecord.put(dbId, new ConcurrentHashMap());
            }
            if (!(tableToRecord = this.dbToTableToCreationRecord.get(dbId)).containsKey(tableId)) {
                tableToRecord.put(tableId, record);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcebergTableCreationRecord> getTableCreationRecordByDbId(long dbId) {
        ArrayList<IcebergTableCreationRecord> records = new ArrayList<IcebergTableCreationRecord>();
        this.readLock();
        try {
            if (!this.dbToTableToCreationRecord.containsKey(dbId)) {
                ArrayList<IcebergTableCreationRecord> arrayList = records;
                return arrayList;
            }
            Map<Long, IcebergTableCreationRecord> tableToRecords = this.dbToTableToCreationRecord.get(dbId);
            for (Map.Entry<Long, IcebergTableCreationRecord> entry : tableToRecords.entrySet()) {
                records.add(entry.getValue());
            }
            ArrayList<IcebergTableCreationRecord> arrayList = records;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isQueueFull() {
        return this.tableCreationRecordQueue.size() >= Config.max_iceberg_table_creation_record_size;
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    class TableCreationComparator
    implements Comparator<IcebergTableCreationRecord> {
        TableCreationComparator() {
        }

        @Override
        public int compare(IcebergTableCreationRecord r1, IcebergTableCreationRecord r2) {
            return r1.getCreateTime().compareTo(r2.getCreateTime());
        }
    }
}

