/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.doris.analysis.CreateTableStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.IcebergProperty;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.SystemIdGenerator;
import org.apache.doris.external.iceberg.HiveCatalog;
import org.apache.doris.external.iceberg.IcebergCatalog;
import org.apache.doris.external.iceberg.util.IcebergUtils;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IcebergCatalogMgr {
    private static final Logger LOG = LogManager.getLogger(IcebergCatalogMgr.class);
    private static final String PROPERTY_MISSING_MSG = "Iceberg %s is null. Please add properties('%s'='xxx') when create iceberg database.";
    private static final ConcurrentHashMap<String, IcebergCatalog> metastoreUriToCatalog = new ConcurrentHashMap();

    public static IcebergCatalog getCatalog(IcebergProperty icebergProperty) throws DdlException {
        String uri = icebergProperty.getHiveMetastoreUris();
        if (!metastoreUriToCatalog.containsKey(uri)) {
            metastoreUriToCatalog.put(uri, IcebergCatalogMgr.createCatalog(icebergProperty));
        }
        return metastoreUriToCatalog.get(uri);
    }

    private static IcebergCatalog createCatalog(IcebergProperty icebergProperty) throws DdlException {
        HiveCatalog catalog;
        CatalogType type = CatalogType.valueOf(icebergProperty.getCatalogType());
        switch (type) {
            case HIVE_CATALOG: {
                catalog = new HiveCatalog();
                break;
            }
            default: {
                throw new DdlException("Unsupported catalog type: " + (Object)((Object)type));
            }
        }
        catalog.initialize(icebergProperty);
        return catalog;
    }

    public static void validateProperties(Map<String, String> properties, boolean isTable) throws DdlException {
        if (properties.size() == 0) {
            throw new DdlException("Please set properties of iceberg, they are: iceberg.database and 'iceberg.hive.metastore.uris'");
        }
        HashMap copiedProps = Maps.newHashMap(properties);
        String icebergDb = (String)copiedProps.get("iceberg.database");
        if (Strings.isNullOrEmpty((String)icebergDb)) {
            throw new DdlException(String.format(PROPERTY_MISSING_MSG, "iceberg.database", "iceberg.database"));
        }
        copiedProps.remove("iceberg.database");
        String hiveMetastoreUris = (String)copiedProps.get("iceberg.hive.metastore.uris");
        if (Strings.isNullOrEmpty((String)hiveMetastoreUris)) {
            throw new DdlException(String.format(PROPERTY_MISSING_MSG, "iceberg.hive.metastore.uris", "iceberg.hive.metastore.uris"));
        }
        copiedProps.remove("iceberg.hive.metastore.uris");
        String icebergCatalogType = (String)copiedProps.get("iceberg.catalog.type");
        if (Strings.isNullOrEmpty((String)icebergCatalogType)) {
            icebergCatalogType = CatalogType.HIVE_CATALOG.name();
            properties.put("iceberg.catalog.type", icebergCatalogType);
        } else {
            copiedProps.remove("iceberg.catalog.type");
        }
        if (!Enums.getIfPresent(CatalogType.class, (String)icebergCatalogType).isPresent()) {
            throw new DdlException("Unknown catalog type: " + icebergCatalogType + ". Current only support HiveCatalog.");
        }
        if (isTable) {
            String icebergTbl = (String)copiedProps.get("iceberg.table");
            if (Strings.isNullOrEmpty((String)icebergTbl)) {
                throw new DdlException(String.format(PROPERTY_MISSING_MSG, "iceberg.table", "iceberg.table"));
            }
            copiedProps.remove("iceberg.table");
        }
        if (!copiedProps.isEmpty()) {
            throw new DdlException("Unknown table properties: " + ((Object)copiedProps).toString());
        }
    }

    public static IcebergTable getTableFromIceberg(long tableId, String tableName, IcebergProperty icebergProperty, TableIdentifier identifier, boolean isTable) throws DdlException {
        IcebergCatalog icebergCatalog = IcebergCatalogMgr.getCatalog(icebergProperty);
        if (isTable && !icebergCatalog.tableExists(identifier)) {
            throw new DdlException(String.format("Table [%s] dose not exist in Iceberg.", identifier.toString()));
        }
        Table icebergTable = icebergCatalog.loadTable(identifier);
        List<Column> columns = IcebergUtils.createSchemaFromIcebergSchema(icebergTable.schema());
        IcebergTable table = new IcebergTable(tableId, tableName, columns, icebergProperty, icebergTable);
        return table;
    }

    public static void createIcebergTable(Database db, CreateTableStmt stmt) throws DdlException {
        String tableName = stmt.getTableName();
        Map<String, String> properties = stmt.getProperties();
        IcebergCatalogMgr.validateProperties(properties, true);
        IcebergProperty icebergProperty = new IcebergProperty(properties);
        String icebergDb = icebergProperty.getDatabase();
        String icebergTbl = icebergProperty.getTable();
        long tableId = SystemIdGenerator.getNextId();
        IcebergTable table = stmt.getColumns().size() > 0 ? new IcebergTable(tableId, tableName, stmt.getColumns(), icebergProperty, null) : IcebergCatalogMgr.getTableFromIceberg(tableId, tableName, icebergProperty, TableIdentifier.of((String[])new String[]{icebergDb, icebergTbl}), true);
        if (!((Boolean)db.createTableWithLock((org.apache.doris.catalog.Table)table, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        LOG.info("successfully create table[{}-{}]", (Object)tableName, (Object)table.getId());
    }

    public static enum CatalogType {
        HIVE_CATALOG;

    }
}

