/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.iceberg;

import java.util.HashMap;
import java.util.List;
import org.apache.doris.catalog.IcebergProperty;
import org.apache.doris.external.iceberg.DorisIcebergException;
import org.apache.doris.external.iceberg.IcebergCatalog;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HiveCatalog
implements IcebergCatalog {
    private static final Logger LOG = LogManager.getLogger(HiveCatalog.class);
    private org.apache.iceberg.hive.HiveCatalog hiveCatalog = new org.apache.iceberg.hive.HiveCatalog();

    @Override
    public void initialize(IcebergProperty icebergProperty) {
        Configuration conf = new Configuration();
        this.hiveCatalog.setConf(conf);
        HashMap<String, String> catalogProperties = new HashMap<String, String>();
        catalogProperties.put("uri", icebergProperty.getHiveMetastoreUris());
        this.hiveCatalog.initialize("hive", catalogProperties);
    }

    @Override
    public boolean tableExists(TableIdentifier tableIdentifier) {
        return this.hiveCatalog.tableExists(tableIdentifier);
    }

    @Override
    public Table loadTable(TableIdentifier tableIdentifier) throws DorisIcebergException {
        try {
            return this.hiveCatalog.loadTable(tableIdentifier);
        }
        catch (Exception e) {
            LOG.warn("Failed to load table[{}] from database[{}], with error: {}", (Object)tableIdentifier.name(), (Object)tableIdentifier.namespace(), (Object)e.getMessage());
            throw new DorisIcebergException(String.format("Failed to load table[%s] from database[%s]", tableIdentifier.name(), tableIdentifier.namespace()), e);
        }
    }

    @Override
    public List<TableIdentifier> listTables(String db) throws DorisIcebergException {
        try {
            return this.hiveCatalog.listTables(Namespace.of((String[])new String[]{db}));
        }
        catch (Exception e) {
            LOG.warn("Failed to list table in database[{}], with error: {}", (Object)db, (Object)e.getMessage());
            throw new DorisIcebergException(String.format("Failed to list table in database[%s]", db), e);
        }
    }

    @Override
    public boolean databaseExists(String db) {
        return this.hiveCatalog.namespaceExists(Namespace.of((String[])new String[]{db}));
    }
}

