/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import org.apache.doris.external.elasticsearch.EsMajorVersion;
import org.apache.doris.external.elasticsearch.EsRestClient;
import org.apache.doris.external.elasticsearch.SearchContext;
import org.apache.doris.external.elasticsearch.SearchPhase;

public class VersionPhase
implements SearchPhase {
    private EsRestClient client;
    private boolean isVersionSet = false;

    public VersionPhase(EsRestClient client) {
        this.client = client;
    }

    @Override
    public void preProcess(SearchContext context) {
        if (context.esTable().esVersion() != null) {
            this.isVersionSet = true;
            context.version(context.esTable().esVersion());
        }
    }

    @Override
    public void execute(SearchContext context) {
        EsMajorVersion version;
        if (this.isVersionSet) {
            return;
        }
        try {
            version = this.client.version();
        }
        catch (Throwable e) {
            version = EsMajorVersion.LATEST;
        }
        context.version(version);
    }
}

