/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.external.elasticsearch.EsMajorVersion;
import org.apache.doris.external.elasticsearch.EsShardPartitions;
import org.apache.doris.external.elasticsearch.EsTablePartitions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchContext {
    private static final Logger LOG = LogManager.getLogger(SearchContext.class);
    private Map<String, String> fetchFieldsContext = Maps.newHashMap();
    private Map<String, String> docValueFieldsContext = Maps.newHashMap();
    private final String sourceIndex;
    private List<String> resolvedIndices = Collections.emptyList();
    private final String type;
    private EsTable table;
    private final List<Column> fullSchema;
    private EsShardPartitions shardPartitions;
    private EsMajorVersion version;
    private boolean nodesDiscovery;

    public SearchContext(EsTable table) {
        this.table = table;
        this.fullSchema = table.getFullSchema();
        this.sourceIndex = table.getIndexName();
        this.type = table.getMappingType();
        this.nodesDiscovery = table.isNodesDiscovery();
    }

    public String sourceIndex() {
        return this.sourceIndex;
    }

    public List<String> resolvedIndices() {
        return this.resolvedIndices;
    }

    public String type() {
        return this.type;
    }

    public List<Column> columns() {
        return this.fullSchema;
    }

    public EsTable esTable() {
        return this.table;
    }

    public Map<String, String> fetchFieldsContext() {
        return this.fetchFieldsContext;
    }

    public Map<String, String> docValueFieldsContext() {
        return this.docValueFieldsContext;
    }

    public void version(EsMajorVersion version) {
        this.version = version;
    }

    public EsMajorVersion version() {
        return this.version;
    }

    public void partitions(EsShardPartitions shardPartitions) {
        this.shardPartitions = shardPartitions;
    }

    public EsShardPartitions partitions() {
        return this.shardPartitions;
    }

    public EsTablePartitions tablePartitions() throws Exception {
        return EsTablePartitions.fromShardPartitions(this.table, this.shardPartitions);
    }

    public boolean nodesDiscovery() {
        return this.nodesDiscovery;
    }
}

