/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class QueryBuilders {
    public static MatchAllQueryBuilder matchAllQuery() {
        return new MatchAllQueryBuilder();
    }

    public static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, int value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, long value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, float value) {
        return new TermQueryBuilder(name, Float.valueOf(value));
    }

    public static TermQueryBuilder termQuery(String name, double value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, boolean value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, Object value) {
        return new TermQueryBuilder(name, value);
    }

    public static WildcardQueryBuilder wildcardQuery(String name, String query) {
        return new WildcardQueryBuilder(name, query);
    }

    public static BoolQueryBuilder boolQuery() {
        return new BoolQueryBuilder();
    }

    public static TermsQueryBuilder termsQuery(String name, Iterable<?> values) {
        return new TermsQueryBuilder(name, values);
    }

    public static ExistsQueryBuilder existsQuery(String name) {
        return new ExistsQueryBuilder(name);
    }

    public static RangeQueryBuilder rangeQuery(String name) {
        return new RangeQueryBuilder(name);
    }

    private static void writeObject(JsonGenerator out, Object value) throws IOException {
        out.writeObject(value);
    }

    static class MatchAllQueryBuilder
    extends QueryBuilder {
        private MatchAllQueryBuilder() {
        }

        @Override
        void toJson(JsonGenerator out) throws IOException {
            out.writeStartObject();
            out.writeFieldName("match_all");
            out.writeStartObject();
            out.writeEndObject();
            out.writeEndObject();
        }
    }

    static class ExistsQueryBuilder
    extends QueryBuilder {
        private final String fieldName;

        ExistsQueryBuilder(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        }

        @Override
        void toJson(JsonGenerator out) throws IOException {
            out.writeStartObject();
            out.writeFieldName("exists");
            out.writeStartObject();
            out.writeStringField("field", this.fieldName);
            out.writeEndObject();
            out.writeEndObject();
        }
    }

    static class WildcardQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final String value;

        public WildcardQueryBuilder(String fieldName, String value) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        void toJson(JsonGenerator out) throws IOException {
            out.writeStartObject();
            out.writeFieldName("wildcard");
            out.writeStartObject();
            out.writeFieldName(this.fieldName);
            out.writeString(this.value);
            out.writeEndObject();
            out.writeEndObject();
        }
    }

    static class RangeQueryBuilder
    extends QueryBuilder {
        private final String field;
        private Object lt;
        private boolean lte;
        private Object gt;
        private boolean gte;
        private String format;

        private RangeQueryBuilder(String field) {
            this.field = Objects.requireNonNull(field, "fieldName");
        }

        private RangeQueryBuilder to(Object value, boolean lte) {
            this.lt = Objects.requireNonNull(value, "value");
            this.lte = lte;
            return this;
        }

        private RangeQueryBuilder from(Object value, boolean gte) {
            this.gt = Objects.requireNonNull(value, "value");
            this.gte = gte;
            return this;
        }

        RangeQueryBuilder lt(Object value) {
            return this.to(value, false);
        }

        RangeQueryBuilder lte(Object value) {
            return this.to(value, true);
        }

        RangeQueryBuilder gt(Object value) {
            return this.from(value, false);
        }

        RangeQueryBuilder gte(Object value) {
            return this.from(value, true);
        }

        RangeQueryBuilder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        void toJson(JsonGenerator out) throws IOException {
            String op;
            if (this.lt == null && this.gt == null) {
                throw new IllegalStateException("Either lower or upper bound should be provided");
            }
            out.writeStartObject();
            out.writeFieldName("range");
            out.writeStartObject();
            out.writeFieldName(this.field);
            out.writeStartObject();
            if (this.gt != null) {
                op = this.gte ? "gte" : "gt";
                out.writeFieldName(op);
                QueryBuilders.writeObject(out, this.gt);
            }
            if (this.lt != null) {
                op = this.lte ? "lte" : "lt";
                out.writeFieldName(op);
                QueryBuilders.writeObject(out, this.lt);
            }
            if (this.format != null) {
                out.writeStringField("format", this.format);
            }
            out.writeEndObject();
            out.writeEndObject();
            out.writeEndObject();
        }
    }

    static class TermsQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Iterable<?> values;

        private TermsQueryBuilder(String fieldName, Iterable<?> values) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.values = Objects.requireNonNull(values, "values");
        }

        @Override
        void toJson(JsonGenerator out) throws IOException {
            out.writeStartObject();
            out.writeFieldName("terms");
            out.writeStartObject();
            out.writeFieldName(this.fieldName);
            out.writeStartArray();
            for (Object value : this.values) {
                QueryBuilders.writeObject(out, value);
            }
            out.writeEndArray();
            out.writeEndObject();
            out.writeEndObject();
        }
    }

    static class TermQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Object value;

        private TermQueryBuilder(String fieldName, Object value) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        void toJson(JsonGenerator out) throws IOException {
            out.writeStartObject();
            out.writeFieldName("term");
            out.writeStartObject();
            out.writeFieldName(this.fieldName);
            QueryBuilders.writeObject(out, this.value);
            out.writeEndObject();
            out.writeEndObject();
        }
    }

    static class BoolQueryBuilder
    extends QueryBuilder {
        private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();

        BoolQueryBuilder() {
        }

        BoolQueryBuilder must(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder);
            this.mustClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder filter(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder);
            this.filterClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder);
            this.mustNotClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder should(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder);
            this.shouldClauses.add(queryBuilder);
            return this;
        }

        @Override
        protected void toJson(JsonGenerator out) throws IOException {
            out.writeStartObject();
            out.writeFieldName("bool");
            out.writeStartObject();
            this.writeJsonArray("must", this.mustClauses, out);
            this.writeJsonArray("filter", this.filterClauses, out);
            this.writeJsonArray("must_not", this.mustNotClauses, out);
            this.writeJsonArray("should", this.shouldClauses, out);
            out.writeEndObject();
            out.writeEndObject();
        }

        private void writeJsonArray(String field, List<QueryBuilder> clauses, JsonGenerator out) throws IOException {
            if (clauses.isEmpty()) {
                return;
            }
            if (clauses.size() == 1) {
                out.writeFieldName(field);
                clauses.get(0).toJson(out);
            } else {
                out.writeArrayFieldStart(field);
                for (QueryBuilder clause : clauses) {
                    clause.toJson(out);
                }
                out.writeEndArray();
            }
        }
    }

    static abstract class QueryBuilder {
        QueryBuilder() {
        }

        abstract void toJson(JsonGenerator var1) throws IOException;
    }
}

