/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import java.util.HashMap;
import java.util.Map;
import org.apache.doris.external.elasticsearch.DorisEsException;
import org.apache.doris.external.elasticsearch.EsNodeInfo;
import org.apache.doris.external.elasticsearch.EsRestClient;
import org.apache.doris.external.elasticsearch.EsShardPartitions;
import org.apache.doris.external.elasticsearch.SearchContext;
import org.apache.doris.external.elasticsearch.SearchPhase;

public class PartitionPhase
implements SearchPhase {
    private EsRestClient client;
    private EsShardPartitions shardPartitions;
    private Map<String, EsNodeInfo> nodesInfo;

    public PartitionPhase(EsRestClient client) {
        this.client = client;
    }

    @Override
    public void execute(SearchContext context) throws DorisEsException {
        this.shardPartitions = this.client.searchShards(context.sourceIndex());
        if (context.nodesDiscovery()) {
            this.nodesInfo = this.client.getHttpNodes();
        } else {
            this.nodesInfo = new HashMap<String, EsNodeInfo>();
            String[] seeds = context.esTable().getSeeds();
            for (int i = 0; i < seeds.length; ++i) {
                this.nodesInfo.put(String.valueOf(i), new EsNodeInfo(String.valueOf(i), seeds[i]));
            }
        }
    }

    @Override
    public void postProcess(SearchContext context) throws DorisEsException {
        context.partitions(this.shardPartitions);
        if ("http".equals(context.esTable().getTransport())) {
            context.partitions().addHttpAddress(this.nodesInfo);
        }
    }
}

