/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.external.elasticsearch.DorisEsException;
import org.apache.doris.external.elasticsearch.EsRestClient;
import org.apache.doris.external.elasticsearch.SearchContext;
import org.apache.doris.external.elasticsearch.SearchPhase;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class MappingPhase
implements SearchPhase {
    private EsRestClient client;
    private String jsonMapping;

    public MappingPhase(EsRestClient client) {
        this.client = client;
    }

    @Override
    public void execute(SearchContext context) throws DorisEsException {
        this.jsonMapping = this.client.getMapping(context.sourceIndex());
    }

    @Override
    public void postProcess(SearchContext context) {
        this.resolveFields(context, this.jsonMapping);
    }

    public void resolveFields(SearchContext searchContext, String indexMapping) throws DorisEsException {
        Iterator keys;
        String docKey;
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)indexMapping);
        JSONObject docData = (JSONObject)jsonObject.get((Object)(docKey = (String)(keys = jsonObject.keySet().iterator()).next()));
        JSONObject mappings = (JSONObject)docData.get((Object)"mappings");
        JSONObject rootSchema = (JSONObject)mappings.get((Object)searchContext.type());
        JSONObject properties = rootSchema == null ? (JSONObject)mappings.get((Object)"properties") : (JSONObject)rootSchema.get((Object)"properties");
        if (properties == null) {
            throw new DorisEsException("index[" + searchContext.sourceIndex() + "] type[" + searchContext.type() + "] mapping not found for the ES Cluster");
        }
        for (Column col : searchContext.columns()) {
            String colName = col.getName();
            if (!properties.containsKey((Object)colName)) continue;
            JSONObject fieldObject = (JSONObject)properties.get((Object)colName);
            this.resolveKeywordFields(searchContext, fieldObject, colName);
            this.resolveDocValuesFields(searchContext, fieldObject, colName);
        }
    }

    private void resolveKeywordFields(SearchContext searchContext, JSONObject fieldObject, String colName) {
        JSONObject fieldsObject;
        String fieldType = (String)fieldObject.get((Object)"type");
        if ("text".equals(fieldType) && (fieldsObject = (JSONObject)fieldObject.get((Object)"fields")) != null) {
            for (Object key : fieldsObject.keySet()) {
                JSONObject innerTypeObject = (JSONObject)fieldsObject.get((Object)((String)key));
                if (!"keyword".equals((String)innerTypeObject.get((Object)"type"))) continue;
                searchContext.fetchFieldsContext().put(colName, colName + "." + key);
            }
        }
    }

    private void resolveDocValuesFields(SearchContext searchContext, JSONObject fieldObject, String colName) {
        String fieldType = (String)fieldObject.get((Object)"type");
        String docValueField = null;
        if (EsTable.DEFAULT_DOCVALUE_DISABLED_FIELDS.contains(fieldType)) {
            JSONObject fieldsObject = (JSONObject)fieldObject.get((Object)"fields");
            if (fieldsObject != null) {
                for (Object key : fieldsObject.keySet()) {
                    JSONObject innerTypeObject = (JSONObject)fieldsObject.get((Object)((String)key));
                    if (EsTable.DEFAULT_DOCVALUE_DISABLED_FIELDS.contains((String)innerTypeObject.get((Object)"type"))) continue;
                    if (innerTypeObject.containsKey((Object)"doc_values")) {
                        boolean docValue = (Boolean)innerTypeObject.get((Object)"doc_values");
                        if (!docValue) continue;
                        docValueField = colName;
                        continue;
                    }
                    docValueField = colName + "." + key;
                }
            }
        } else {
            Boolean docValue;
            if (fieldObject.containsKey((Object)"doc_values") && !(docValue = (Boolean)fieldObject.get((Object)"doc_values")).booleanValue()) {
                return;
            }
            docValueField = colName;
        }
        if (StringUtils.isNotEmpty((CharSequence)docValueField)) {
            searchContext.docValueFieldsContext().put(colName, docValueField);
        }
    }
}

