/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import java.util.Map;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.PartitionDesc;
import org.apache.doris.analysis.RangePartitionDesc;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.json.simple.JSONObject;

public class EsUtil {
    public static void analyzePartitionAndDistributionDesc(PartitionDesc partitionDesc, DistributionDesc distributionDesc) throws AnalysisException {
        if (partitionDesc == null && distributionDesc == null) {
            return;
        }
        if (partitionDesc != null) {
            if (!(partitionDesc instanceof RangePartitionDesc)) {
                throw new AnalysisException("Elasticsearch table only permit range partition");
            }
            RangePartitionDesc rangePartitionDesc = (RangePartitionDesc)partitionDesc;
            EsUtil.analyzePartitionDesc(rangePartitionDesc);
        }
        if (distributionDesc != null) {
            throw new AnalysisException("could not support distribution clause");
        }
    }

    private static void analyzePartitionDesc(RangePartitionDesc partDesc) throws AnalysisException {
        if (partDesc.getPartitionColNames() == null || partDesc.getPartitionColNames().isEmpty()) {
            throw new AnalysisException("No partition columns.");
        }
        if (partDesc.getPartitionColNames().size() > 1) {
            throw new AnalysisException("Elasticsearch table's partition column could only be a single column");
        }
    }

    public static JSONObject getJsonObject(JSONObject jsonObject, String key, int fromIndex) {
        int firstOccr = key.indexOf(46, fromIndex);
        if (firstOccr == -1) {
            String token = key.substring(key.lastIndexOf(46) + 1);
            if (jsonObject.containsKey((Object)token)) {
                return (JSONObject)jsonObject.get((Object)token);
            }
            return null;
        }
        String fieldName = key.substring(fromIndex, firstOccr);
        if (jsonObject.containsKey((Object)fieldName)) {
            return EsUtil.getJsonObject((JSONObject)jsonObject.get((Object)fieldName), key, firstOccr + 1);
        }
        return null;
    }

    public static boolean getBoolean(Map<String, String> properties, String name) throws DdlException {
        String property = properties.get(name).trim();
        try {
            return Boolean.parseBoolean(property);
        }
        catch (Exception e) {
            throw new DdlException(String.format("fail to parse %s, %s = %s, `%s` should be like 'true' or 'false'\uff0c value should be double quotation marks", name, name, property, name));
        }
    }
}

