/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.SinglePartitionInfo;
import org.apache.doris.common.DdlException;
import org.apache.doris.external.elasticsearch.DorisEsException;
import org.apache.doris.external.elasticsearch.EsShardPartitions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsTablePartitions {
    private static final Logger LOG = LogManager.getLogger(EsTablePartitions.class);
    private PartitionInfo partitionInfo = null;
    private Map<Long, String> partitionIdToIndices = Maps.newHashMap();
    private Map<String, EsShardPartitions> partitionedIndexStates = Maps.newHashMap();
    private Map<String, EsShardPartitions> unPartitionedIndexStates = Maps.newHashMap();

    public static EsTablePartitions fromShardPartitions(EsTable esTable, EsShardPartitions shardPartitions) throws DorisEsException, DdlException {
        EsTablePartitions esTablePartitions = new EsTablePartitions();
        RangePartitionInfo partitionInfo = null;
        if (esTable.getPartitionInfo() != null) {
            if (esTable.getPartitionInfo() instanceof RangePartitionInfo) {
                RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)esTable.getPartitionInfo();
                partitionInfo = new RangePartitionInfo(rangePartitionInfo.getPartitionColumns());
                esTablePartitions.setPartitionInfo(partitionInfo);
                if (LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    int idx = 0;
                    for (Column column : rangePartitionInfo.getPartitionColumns()) {
                        if (idx != 0) {
                            sb.append(", ");
                        }
                        sb.append("`").append(column.getName()).append("`");
                        ++idx;
                    }
                    sb.append(")");
                    LOG.debug("begin to parse es table [{}] state from search shards, with partition info [{}]", (Object)esTable.getName(), (Object)sb.toString());
                }
            } else if (esTable.getPartitionInfo() instanceof SinglePartitionInfo) {
                LOG.debug("begin to parse es table [{}] state from search shards, with no partition info", (Object)esTable.getName());
            } else {
                throw new DorisEsException("es table only support range partition, but current partition type is " + (Object)((Object)esTable.getPartitionInfo().getType()));
            }
        }
        esTablePartitions.addIndexState(esTable.getIndexName(), shardPartitions);
        LOG.debug("add index {} to es table {}", (Object)shardPartitions, (Object)esTable.getName());
        if (partitionInfo != null) {
            ArrayList<EsShardPartitions> esShardPartitionsList = new ArrayList<EsShardPartitions>(esTablePartitions.getPartitionedIndexStates().values());
            esShardPartitionsList.sort(Comparator.comparing(EsShardPartitions::getPartitionKey));
            long partitionId = 0L;
            for (EsShardPartitions esShardPartitions : esShardPartitionsList) {
                PartitionItem item = partitionInfo.handleNewSinglePartitionDesc(esShardPartitions.getPartitionDesc(), partitionId, false);
                esTablePartitions.addPartition(esShardPartitions.getIndexName(), partitionId);
                esShardPartitions.setPartitionId(partitionId);
                ++partitionId;
                LOG.debug("add partition to es table [{}] with range [{}]", (Object)esTable.getName(), item.getItems());
            }
        }
        return esTablePartitions;
    }

    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public void setPartitionInfo(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public Map<Long, String> getPartitionIdToIndices() {
        return this.partitionIdToIndices;
    }

    public void addPartition(String indexName, long partitionId) {
        this.partitionIdToIndices.put(partitionId, indexName);
    }

    public void addIndexState(String indexName, EsShardPartitions indexState) {
        if (indexState.getPartitionDesc() != null) {
            this.partitionedIndexStates.put(indexName, indexState);
        } else {
            this.unPartitionedIndexStates.put(indexName, indexState);
        }
    }

    public Map<String, EsShardPartitions> getPartitionedIndexStates() {
        return this.partitionedIndexStates;
    }

    public Map<String, EsShardPartitions> getUnPartitionedIndexStates() {
        return this.unPartitionedIndexStates;
    }

    public EsShardPartitions getEsShardPartitions(long partitionId) {
        if (this.partitionIdToIndices.containsKey(partitionId)) {
            return this.partitionedIndexStates.get(this.partitionIdToIndices.get(partitionId));
        }
        return null;
    }

    public EsShardPartitions getEsShardPartitions(String indexName) {
        if (this.partitionedIndexStates.containsKey(indexName)) {
            return this.partitionedIndexStates.get(indexName);
        }
        return this.unPartitionedIndexStates.get(indexName);
    }
}

