/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import com.google.common.base.Strings;
import org.apache.doris.thrift.TNetworkAddress;
import org.json.simple.JSONObject;

public class EsShardRouting {
    private final String indexName;
    private final int shardId;
    private final boolean isPrimary;
    private final TNetworkAddress address;
    private TNetworkAddress httpAddress;
    private final String nodeId;

    public EsShardRouting(String indexName, int shardId, boolean isPrimary, TNetworkAddress address, String nodeId) {
        this.indexName = indexName;
        this.shardId = shardId;
        this.isPrimary = isPrimary;
        this.address = address;
        this.nodeId = nodeId;
    }

    public static EsShardRouting newSearchShard(String indexName, int shardId, boolean isPrimary, String nodeId, JSONObject nodesMap) {
        JSONObject nodeInfo = (JSONObject)nodesMap.get((Object)nodeId);
        String[] transportAddr = ((String)nodeInfo.get((Object)"transport_address")).split(":");
        String thriftPort = (String)((JSONObject)nodeInfo.get((Object)"attributes")).get((Object)"thrift_port");
        TNetworkAddress addr = null;
        if (!Strings.isNullOrEmpty((String)thriftPort)) {
            addr = new TNetworkAddress(transportAddr[0], Integer.parseInt(thriftPort));
        }
        return new EsShardRouting(indexName, shardId, isPrimary, addr, nodeId);
    }

    public int getShardId() {
        return this.shardId;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public TNetworkAddress getAddress() {
        return this.address;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public TNetworkAddress getHttpAddress() {
        return this.httpAddress;
    }

    public void setHttpAddress(TNetworkAddress httpAddress) {
        this.httpAddress = httpAddress;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return "EsShardRouting{indexName='" + this.indexName + '\'' + ", shardId=" + this.shardId + ", isPrimary=" + this.isPrimary + ", address=" + this.address + ", httpAddress=" + this.httpAddress + ", nodeId='" + this.nodeId + '\'' + '}';
    }
}

