/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.external.elasticsearch.DorisEsException;
import org.apache.doris.external.elasticsearch.EsNodeInfo;
import org.apache.doris.external.elasticsearch.EsShardRouting;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class EsShardPartitions {
    private static final Logger LOG = LogManager.getLogger(EsShardPartitions.class);
    private final String indexName;
    private Map<Integer, List<EsShardRouting>> shardRoutings;
    private SinglePartitionDesc partitionDesc;
    private PartitionKey partitionKey;
    private long partitionId = -1L;

    public EsShardPartitions(String indexName) {
        this.indexName = indexName;
        this.shardRoutings = Maps.newHashMap();
        this.partitionDesc = null;
        this.partitionKey = null;
    }

    public static EsShardPartitions findShardPartitions(String indexName, String searchShards) throws DorisEsException {
        EsShardPartitions partitions = new EsShardPartitions(indexName);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)searchShards);
        JSONArray shards = (JSONArray)jsonObject.get((Object)"shards");
        int size = shards.size();
        for (int i = 0; i < size; ++i) {
            ArrayList singleShardRouting = Lists.newArrayList();
            JSONArray shardsArray = (JSONArray)shards.get(i);
            int arraySize = shardsArray.size();
            for (int j = 0; j < arraySize; ++j) {
                JSONObject indexShard = (JSONObject)shardsArray.get(j);
                String shardState = (String)indexShard.get((Object)"state");
                if (!"STARTED".equalsIgnoreCase(shardState) && !"RELOCATING".equalsIgnoreCase(shardState)) continue;
                try {
                    singleShardRouting.add(EsShardRouting.newSearchShard((String)indexShard.get((Object)"index"), ((Long)indexShard.get((Object)"shard")).intValue(), (Boolean)indexShard.get((Object)"primary"), (String)indexShard.get((Object)"node"), (JSONObject)jsonObject.get((Object)"nodes")));
                    continue;
                }
                catch (Exception e) {
                    LOG.error("fetch index [{}] shard partitions failure", (Object)indexName, (Object)e);
                    throw new DorisEsException("fetch [" + indexName + "] shard partitions failure [" + e.getMessage() + "]");
                }
            }
            if (singleShardRouting.isEmpty()) {
                LOG.warn("could not find a healthy allocation for [{}][{}]", (Object)indexName, (Object)i);
            }
            partitions.addShardRouting(i, singleShardRouting);
        }
        return partitions;
    }

    public void addHttpAddress(Map<String, EsNodeInfo> nodesInfo) {
        for (Map.Entry<Integer, List<EsShardRouting>> entry : this.shardRoutings.entrySet()) {
            List<EsShardRouting> shardRoutings = entry.getValue();
            for (EsShardRouting shardRouting : shardRoutings) {
                String nodeId = shardRouting.getNodeId();
                if (nodesInfo.containsKey(nodeId)) {
                    shardRouting.setHttpAddress(nodesInfo.get(nodeId).getPublishAddress());
                    continue;
                }
                shardRouting.setHttpAddress(this.randomAddress(nodesInfo));
            }
        }
    }

    public TNetworkAddress randomAddress(Map<String, EsNodeInfo> nodesInfo) {
        int seed = new Random().nextInt(Short.MAX_VALUE) % nodesInfo.size();
        EsNodeInfo[] nodeInfos = nodesInfo.values().toArray(new EsNodeInfo[0]);
        return nodeInfos[seed].getPublishAddress();
    }

    public void addShardRouting(int shardId, List<EsShardRouting> singleShardRouting) {
        this.shardRoutings.put(shardId, singleShardRouting);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Map<Integer, List<EsShardRouting>> getShardRoutings() {
        return this.shardRoutings;
    }

    public SinglePartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    public void setPartitionDesc(SinglePartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(PartitionKey partitionKey) {
        this.partitionKey = partitionKey;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(long partitionId) {
        this.partitionId = partitionId;
    }

    public String toString() {
        return "EsIndexState [indexName=" + this.indexName + ", partitionDesc=" + this.partitionDesc + ", partitionKey=" + this.partitionKey + "]";
    }
}

